/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.structures;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.ConfigAccessor;
import org.kingdoms.constants.land.FuelContainer;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.ItemMatcher;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.nms.HologramFactory;
import org.kingdoms.utils.string.StringUtils;

public final class FuelManager
implements Listener {
    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)Kingdoms.get(), () -> {
            int keep;
            Item item = event.getItemDrop();
            if (!item.isValid()) {
                return;
            }
            SimpleLocation droppedLocation = SimpleLocation.of(item.getLocation());
            AtomicReference closestStructure = new AtomicReference();
            AtomicBoolean isFull = new AtomicBoolean();
            LocationUtils.findBlock(item.getLocation().getBlock(), 3, block -> {
                Pair previouslyClosest;
                ConfigSection variant;
                SimpleLocation loc = SimpleLocation.of(block);
                SimpleChunkLocation chunk = loc.toSimpleChunkLocation();
                Land land = chunk.getLand();
                if (land == null || !land.isClaimed()) {
                    return false;
                }
                Structure structure = land.getStructures().get(loc);
                if (structure == null) {
                    return false;
                }
                if (!(structure instanceof FuelContainer)) {
                    return false;
                }
                ConfigAccessor settings = ((StructureStyle)structure.getStyle()).getOption("fuel").getSection();
                if (!settings.getBoolean("enabled")) {
                    return false;
                }
                ItemMatcher matched = null;
                ItemStack itemStack = event.getItemDrop().getItemStack();
                Iterator<ConfigSection> iterator = settings.gotoSection("variants").getSection().getSections().values().iterator();
                while (iterator.hasNext() && !(matched = new ItemMatcher(variant = iterator.next())).matches(itemStack)) {
                    matched = null;
                }
                if (matched == null) {
                    return false;
                }
                FuelContainer fuelContainer = (FuelContainer)((Object)structure);
                double capacity = fuelContainer.getMaxFuel();
                boolean currentFull = fuelContainer.hasFuel(capacity);
                if (currentFull && !isFull.get()) {
                    return false;
                }
                if (currentFull == isFull.get() && (previouslyClosest = (Pair)closestStructure.get()) != null) {
                    double newDist;
                    SimpleLocation prevLoc = ((Structure)previouslyClosest.getKey()).getLocation();
                    SimpleLocation newLoc = structure.getLocation();
                    double prevDist = droppedLocation.distance(prevLoc);
                    if (prevDist < (newDist = droppedLocation.distance(newLoc))) {
                        return false;
                    }
                }
                isFull.set(currentFull);
                closestStructure.set(Pair.of(structure, matched));
                return false;
            });
            Pair pair = (Pair)closestStructure.get();
            if (pair == null) {
                return;
            }
            Structure structure = (Structure)pair.getKey();
            FuelContainer fuelContainer = (FuelContainer)((Object)structure);
            ItemStack itemStack = item.getItemStack();
            if (!item.isValid() || item.isDead()) {
                return;
            }
            Player player = event.getPlayer();
            if (isFull.get()) {
                KingdomsLang.STRUCTURE_FUEL_FULL.sendError((CommandSender)player, "fuel", StringUtils.toFancyNumber(fuelContainer.getFuel()));
                structure.playSound("fuel-full");
                return;
            }
            int amount = itemStack.getAmount();
            ParticleDisplay.of(Particle.SMOKE_NORMAL).offset(0.3).withCount(amount * 5).spawn(item.getLocation());
            structure.playSound("fuel-fill");
            ItemMatcher matched = (ItemMatcher)pair.getValue();
            double oldAmount = fuelContainer.getFuel();
            double costPerItem = matched.getSection().getDouble("fill-amount-per-item");
            double added = costPerItem * (double)amount;
            double capacity = fuelContainer.getMaxFuel();
            fuelContainer.setFuel(Math.min(capacity, fuelContainer.getFuel() + added));
            if (fuelContainer.getFuel() == capacity) {
                double needed = capacity - oldAmount;
                keep = (int)Math.floor((added - needed) / costPerItem);
            } else {
                keep = 0;
            }
            Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> {
                if (keep > 0) {
                    itemStack.setAmount(keep);
                    item.setItemStack(itemStack);
                } else {
                    item.remove();
                }
            });
            MessageBuilder settings = new MessageBuilder().viewer(KingdomPlayer.getKingdomPlayer((OfflinePlayer)player)).raws("old-fuel", StringUtils.toFancyNumber(oldAmount), "added-fuel", StringUtils.toFancyNumber(added), "fuel", StringUtils.toFancyNumber(fuelContainer.getFuel()));
            String msg = (fuelContainer.getFuel() == capacity ? KingdomsLang.STRUCTURE_FUEL_MAXXED : KingdomsLang.STRUCTURE_FUEL_FILL).parse(settings);
            Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> {
                ArmorStand holo = HologramFactory.spawnUpwards(structure.getLocation().toBukkitLocation(), msg);
                Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> ((ArmorStand)holo).remove(), 100L);
            });
        }, 7L);
    }
}

