/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.teleportation;

import java.util.function.Consumer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.abstraction.MoveSensitiveAction;
import org.kingdoms.managers.teleportation.TpManager;

public class TeleportTask
extends MoveSensitiveAction {
    public final BukkitTask task;
    public final Player player;

    public TeleportTask(Player player, BukkitTask task) {
        this.task = task;
        this.player = player;
    }

    public TeleportTask assignBasicMoveChecks() {
        this.onAnyMove(p -> {
            KingdomsLang.TELEPORTS_MOVED.sendError((CommandSender)this.player, new Object[0]);
            return true;
        });
        return this;
    }

    public static TeleportTask timer(final Player player, final int timer, final Consumer<BukkitRunnable> onCountdown, final Runnable onFinish) {
        BukkitTask task = new BukkitRunnable(){
            int timed;
            {
                this.timed = timer;
            }

            public void run() {
                if (this.timed <= 0) {
                    onFinish.run();
                    TpManager.end((Entity)player);
                    this.cancel();
                } else {
                    onCountdown.accept(this);
                    --this.timed;
                }
            }
        }.runTaskTimer((Plugin)Kingdoms.get(), 0L, 20L);
        return new TeleportTask(player, task);
    }
}

