/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.turrets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Zombie;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.TurretType;
import org.kingdoms.constants.land.turrets.objects.RangedTurret;
import org.kingdoms.data.KingdomsDataCenter;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.turrets.TurretFactory;
import org.kingdoms.utils.string.StringUtils;

public final class TurretBenchmark {
    private final int turretPerChunk;
    private final int totalChunks;
    private final int entitiesPerTurret;
    private final Kingdom kingdom = KingdomsDataCenter.get().getKingdomManager().getKingdoms().stream().filter(x -> x.getHome() != null || x.getNexus() != null).findFirst().get();
    private final SimpleChunkLocation center = this.kingdom.getNexus() == null ? SimpleChunkLocation.of(this.kingdom.getHome()) : this.kingdom.getNexus().toSimpleChunkLocation();
    private final ThreadLocalRandom random = ThreadLocalRandom.current();
    private final TurretStyle style = TurretRegistry.getStyle("arrow");
    private final List<Turret> addedTurrets;
    private final Iterator<SimpleChunkLocation> radiusedIterator;
    int occupied = 0;
    Iterator<Turret> iter;
    int spawnedEntities = 0;

    public TurretBenchmark(int turretsPerChunk, int chunks, int entitiesPerTurret) {
        List<SimpleChunkLocation> radiused = Arrays.asList(this.center.getChunksAround((int)(Math.sqrt(chunks) / 2.0), true));
        this.totalChunks = radiused.size();
        this.entitiesPerTurret = entitiesPerTurret;
        this.turretPerChunk = turretsPerChunk;
        this.addedTurrets = new ArrayList<Turret>(turretsPerChunk * chunks);
        this.radiusedIterator = radiused.iterator();
        KLogger.info("Chosen kingdom for benchmark: " + this.kingdom.getName());
        KLogger.info("Generating with a radius of " + radiused.size());
        ((SimplePluginManager)Bukkit.getPluginManager()).useTimings(false);
        TurretFactory.setDisabled(true);
        this.generateTurrets();
    }

    public static void afterLoad(Runnable runnable) {
        Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), runnable, 100L);
    }

    private void generateTurrets() {
        if (!this.radiusedIterator.hasNext()) {
            this.iter = this.addedTurrets.iterator();
            this.center.getBukkitWorld().setFullTime(13000L);
            this.generateEntities();
            return;
        }
        SimpleChunkLocation simpleChunk = this.radiusedIterator.next();
        if (!this.kingdom.isClaimed(simpleChunk)) {
            this.kingdom.claim(simpleChunk, this.kingdom.getKing(), ClaimLandEvent.Reason.CUSTOM);
        }
        Chunk chunk = simpleChunk.toChunk();
        Land land = Land.getLand(chunk);
        World world = chunk.getWorld();
        ++this.occupied;
        chunk.setForceLoaded(true);
        chunk.load(true);
        if (land.getTurrets().size() < this.turretPerChunk) {
            for (int j = 0; j < this.turretPerChunk; ++j) {
                int locX = (simpleChunk.getX() << 4) + 8 + this.random.nextInt(-8, 8);
                int locZ = (simpleChunk.getZ() << 4) + 8 + this.random.nextInt(-8, 8);
                SimpleLocation turretLoc = new SimpleLocation(world.getName(), locX, world.getHighestBlockYAt(locX, locZ), locZ);
                RangedTurret turret = (RangedTurret)((TurretType)this.style.getType()).build(new KingdomItemBuilder(this.style, turretLoc));
                land.getTurrets().put(turretLoc, turret);
                turret.setAmmo(Integer.MAX_VALUE);
                turret.setLevel(3);
                this.addedTurrets.add(turret);
            }
        } else {
            land.getTurrets().values().stream().filter(x -> x instanceof RangedTurret).forEach(x -> ((RangedTurret)x).setAmmo(Integer.MAX_VALUE));
        }
        if (this.occupied % 5 == 0) {
            KLogger.info("Chunk Prepration Progress: " + this.occupied + '/' + this.totalChunks);
            TurretBenchmark.tps();
        }
        TurretFactory.getTurretLands().put(land.getLocation(), land);
        Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), this::generateTurrets, 20L);
    }

    private static void tps() {
        ConsoleCommandSender sender = Bukkit.getConsoleSender();
        String[] tps = (String[])Arrays.stream(MinecraftServer.getServer().recentTps).mapToObj(StringUtils::toFancyNumber).toArray(String[]::new);
        StringBuilder sb = new StringBuilder(ChatColor.GOLD + "TPS from last 1m: " + tps[0] + ", 5m: " + tps[1] + ", 15m: " + tps[2]);
        sender.sendMessage(sb.substring(0, sb.length() - 2));
        sender.sendMessage(ChatColor.GOLD + "Current Memory Usage: " + ChatColor.GREEN + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L + "/" + Runtime.getRuntime().totalMemory() / 0x100000L + " mb (Max: " + Runtime.getRuntime().maxMemory() / 0x100000L + " mb)");
    }

    void end() {
        KLogger.info("Done, open fire");
        ((SimplePluginManager)Bukkit.getPluginManager()).useTimings(true);
        TurretFactory.setDisabled(false);
    }

    private void generateEntities() {
        KLogger.info("Generating entities...");
        for (int i = 0; i < 10; ++i) {
            if (!this.iter.hasNext()) {
                this.end();
                return;
            }
            Turret turret = this.iter.next();
            World world = turret.getLocation().getBukkitWorld();
            for (int j = 0; j < this.entitiesPerTurret; ++j) {
                SimpleLocation loc = turret.getLocation().getRelative(this.random.nextInt(-10, 10), this.random.nextInt(0, 10), this.random.nextInt(-10, 10));
                world.spawn(loc.toBukkitLocation(), Zombie.class);
                ++this.spawnedEntities;
            }
        }
        KLogger.info("Spawned entites: " + this.spawnedEntities + '/' + this.addedTurrets.size() * this.entitiesPerTurret);
        Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), this::generateEntities, 20L);
    }
}

