/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.turrets;

import java.util.UUID;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.NPC;
import org.bukkit.entity.Player;
import org.bukkit.entity.WaterMob;
import org.bukkit.event.Event;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.objects.Regulator;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.TurretType;
import org.kingdoms.constants.land.turrets.objects.InfernoTurret;
import org.kingdoms.constants.land.turrets.objects.RangedTurret;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.items.turrets.TurretActivateEvent;
import org.kingdoms.events.items.turrets.TurretAmmoFillEvent;
import org.kingdoms.libs.xseries.ReflectionUtils;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextBuilder;
import org.kingdoms.managers.entity.KingdomEntityRegistry;
import org.kingdoms.managers.entity.types.KingdomEntity;
import org.kingdoms.managers.entity.types.KingdomLandEntity;
import org.kingdoms.managers.turrets.TurretFactory;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.cache.EnumCache;
import org.kingdoms.utils.internal.enumeration.QuickEnumSet;

final class TurretTask
extends BukkitRunnable {
    private static final QuickEnumSet<EntityType> IGNORED_TYPES = new QuickEnumSet((Enum[])EnumCache.ENTITY_TYPES);

    protected TurretTask() {
    }

    public void run() {
        if (TurretFactory.isDisabled()) {
            return;
        }
        for (Land land : TurretFactory.TURRET_LANDS.values()) {
            Regulator regulator = land.getStructure(Regulator.class);
            Kingdom kingdom = land.getKingdom();
            if (kingdom == null) continue;
            World world = land.getLocation().getBukkitWorld();
            for (Turret turret : land.getTurrets().values()) {
                TurretStyle style = (TurretStyle)turret.getStyle();
                TurretType type = (TurretType)style.getType();
                if (!type.isRanged()) continue;
                RangedTurret rangedTurret = (RangedTurret)turret;
                if (rangedTurret.isOutOfAmmo() && regulator != null && regulator.hasRule(Regulator.Rule.AUTO_FILL_TURRETS)) {
                    int maxAmmo = rangedTurret.getMaxAmmo(kingdom);
                    long cost = (long)MathUtils.eval(((StructureStyle)regulator.getStyle()).getOption("auto-fill-cost").getMathExpression(), new PlaceholderContextBuilder().withContext(kingdom).raw("maxAmmo", maxAmmo));
                    if (kingdom.hasResourcePoints(cost)) {
                        TurretAmmoFillEvent ammoEvent = new TurretAmmoFillEvent(turret, maxAmmo, cost, TurretAmmoFillEvent.FillType.REGULATOR, null);
                        ammoEvent.getMetadata().put(Regulator.NS, regulator);
                        Bukkit.getPluginManager().callEvent((Event)ammoEvent);
                        if (!ammoEvent.isCancelled()) {
                            kingdom.addResourcePoints(-cost);
                            rangedTurret.setAmmo(ammoEvent.getAmount());
                        }
                    }
                }
                if (turret.checkup() || rangedTurret.isManual()) continue;
                double range = rangedTurret.getRange(kingdom);
                int targets = rangedTurret.getMaxTargets(kingdom);
                Location origin = turret.getLocation().toBukkitLocation(world);
                boolean targetNotFound = true;
                for (Entity entity : world.getNearbyEntities(origin, range, range, range)) {
                    TurretActivateEvent event;
                    Kingdom targetKingdom;
                    LivingEntity target;
                    if (IGNORED_TYPES.contains(entity.getType()) || entity.isDead() || entity.hasMetadata("NPC") || TurretFactory.INVULNERABLE.containsKey(entity.getEntityId()) || (target = (LivingEntity)entity).isInvulnerable() || turret.targetCheckup(target)) continue;
                    KingdomPlayer kp = null;
                    if (target.getType() == EntityType.PLAYER) {
                        Boolean attr;
                        Player player = (Player)target;
                        if (PlayerUtils.invulnerableGameMode(player) || ServiceHandler.isVanished(player) || ServiceHandler.isInGodMode(player) || PlayerUtils.isEffectivelyInvisible(player) && !turret.canDetectInvisible(kingdom) || regulator != null && (attr = regulator.hasAttribute((OfflinePlayer)player, Regulator.Attribute.TURRET_CEASEFIRE)) != null && attr == false || (kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player)).isAdmin() || (!type.isEnemies() || !type.isFriends()) && (StandardRelationAttribute.TURRET_CEASEFIRE.hasAttribute(targetKingdom = kp.getKingdom(), kingdom) ? !type.isFriends() : !type.isEnemies())) {
                            continue;
                        }
                    } else {
                        KingdomLandEntity landEntity;
                        Land source;
                        KingdomEntity kingdomEntity;
                        LivingEntity livingEntity;
                        UUID owner = null;
                        if (entity.getType() == EntityType.WITHER && (livingEntity = (LivingEntity)entity).getHealth() <= 150.0) continue;
                        if (owner == null) {
                            owner = ServiceHandler.getPetOwner(entity);
                        }
                        if (owner != null && StandardRelationAttribute.TURRET_CEASEFIRE.hasAttribute(targetKingdom = (kp = KingdomPlayer.getKingdomPlayer(owner)).getKingdom(), kingdom) || (kingdomEntity = KingdomEntityRegistry.getKingdomEntity((Entity)target)) instanceof KingdomLandEntity && (source = (landEntity = (KingdomLandEntity)kingdomEntity).getLand()).getKingdomId().equals(land.getKingdomId())) continue;
                    }
                    if (!type.activate(event = new TurretActivateEvent(target, turret, kingdom, land, origin, kp))) continue;
                    targetNotFound = false;
                    rangedTurret.postActivation(kingdom);
                    if (--targets != 0) continue;
                    break;
                }
                if (!targetNotFound || !(turret instanceof InfernoTurret)) continue;
                InfernoTurret inferno = (InfernoTurret)turret;
                inferno.stop();
            }
        }
    }

    static {
        IGNORED_TYPES.addAll((Enum[])new EntityType[]{EntityType.IRON_GOLEM, EntityType.SNOWMAN, EntityType.ARMOR_STAND});
        if (ReflectionUtils.supports(19)) {
            IGNORED_TYPES.add(EntityType.ALLAY);
        }
        for (EntityType entityType : EnumCache.ENTITY_TYPES) {
            Class entityClazz = entityType.getEntityClass();
            if (entityClazz != null && LivingEntity.class.isAssignableFrom(entityClazz) && !Stream.of(Animals.class, WaterMob.class, NPC.class).anyMatch(x -> x.isAssignableFrom(entityClazz))) continue;
            IGNORED_TYPES.add(entityType);
        }
    }
}

