/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.services;

import java.util.Arrays;
import java.util.Locale;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.context.ContextCalculator;
import net.luckperms.api.context.ContextConsumer;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.services.Service;

public final class ServiceLuckPerms
implements ContextCalculator<Player>,
Service {
    private static final String[] RELATIONS = (String[])Arrays.stream(KingdomRelation.VALUES).map(x -> x.name().toLowerCase(Locale.ENGLISH)).toArray(String[]::new);
    private static final ServiceLuckPerms INSTANCE;

    public static void init() {
    }

    @Override
    public void disable() {
        RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(LuckPerms.class);
        if (provider != null) {
            LuckPerms luckPerms = (LuckPerms)provider.getProvider();
            luckPerms.getContextManager().unregisterCalculator((ContextCalculator)INSTANCE);
        }
    }

    public void calculate(@NonNull Player player, @NonNull ContextConsumer contextConsumer) {
        Kingdom kingdom;
        String relation;
        Land land = Land.getLand(player.getLocation());
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        String string = relation = land == null || !land.isClaimed() ? "wilderness" : null;
        if (relation == null && (kingdom = land.getKingdom()) != null) {
            relation = kingdom.getRelationWith(kp.getKingdom()).name().toLowerCase(Locale.ENGLISH);
        }
        if (relation != null) {
            contextConsumer.accept("territory", relation);
        }
        contextConsumer.accept("hasKingdom", Boolean.toString(kp.hasKingdom()));
    }

    @NotNull
    public ContextSet estimatePotentialContexts() {
        ImmutableContextSet.Builder builder = ImmutableContextSet.builder();
        builder.add("hasKingdom", "true");
        builder.add("hasKingdom", "false");
        builder.add("territory", "wilderness");
        for (String relation : RELATIONS) {
            builder.add("territory", relation);
        }
        return builder.build();
    }

    static {
        RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(LuckPerms.class);
        ServiceLuckPerms instance = null;
        if (provider != null) {
            LuckPerms luckPerms = (LuckPerms)provider.getProvider();
            instance = new ServiceLuckPerms();
            luckPerms.getContextManager().registerCalculator((ContextCalculator)instance);
            MessageHandler.sendConsolePluginMessage("&2Successfully registered LuckPerms context.");
        } else {
            MessageHandler.sendConsolePluginMessage("&cCould not register LuckPerms context.");
        }
        INSTANCE = instance;
    }
}

