/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.inventory.meta.ItemMeta;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.MessagePiece;
import org.kingdoms.locale.provider.MessageBuilder;

public final class ItemUtil {
    public static void translate(ItemMeta meta, MessageBuilder settings) {
        if (meta.hasDisplayName()) {
            MessageObject itemTitle = MessageCompiler.compile(meta.getDisplayName());
            meta.setDisplayName(itemTitle.buildPlain(settings));
        }
        if (meta.hasLore()) {
            List lores = meta.getLore();
            ArrayList<String> newLores = new ArrayList<String>();
            MessageObject lastColor = null;
            for (String lore : lores) {
                MessageObject loreLine = MessageCompiler.compile(lore);
                MessageObject newLastColors = loreLine.findLastColors();
                if (lastColor != null) {
                    loreLine = lastColor.merge(loreLine);
                }
                if (newLastColors != null) {
                    lastColor = newLastColors;
                }
                List<MessageObject> newlines = loreLine.splitBy(piece -> piece instanceof MessagePiece.NewLine);
                for (MessageObject line : newlines) {
                    newLores.add(line.buildPlain(settings));
                }
            }
            meta.setLore(newLores);
        }
    }
}

