/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.libs.xseries.ReflectionUtils;
import org.kingdoms.utils.paper.PaperLib;
import org.kingdoms.utils.platform.Platform;

public final class PaperUtils {
    public static void init() {
        if (!Platform.PAPER.isAvailable()) {
            return;
        }
        PaperLib.init(ReflectionUtils::supports);
    }

    public static void prepareChunksIgnored(int timer, Location loc) {
        if (!Platform.PAPER.isAvailable()) {
            return;
        }
        boolean isUrgent = timer < 5;
        World world = loc.getWorld();
        int viewDist = Bukkit.getViewDistance() / 2;
        for (SimpleChunkLocation chunk : SimpleChunkLocation.of(loc).getChunksAround(viewDist)) {
            PaperLib.getAsyncChunks().getChunkAtAsync(world, chunk.getX(), chunk.getZ(), true, isUrgent);
        }
    }

    public static CompletableFuture<Void> prepareChunks(SimpleChunkLocation centerChunk) {
        if (!Platform.PAPER.isAvailable()) {
            return CompletableFuture.completedFuture(null);
        }
        int viewDist = Bukkit.getViewDistance() / 2;
        return PaperUtils.prepareChunks(Arrays.asList(centerChunk.getChunksAround(viewDist)));
    }

    public static CompletableFuture<Void> prepareChunks(Collection<SimpleChunkLocation> chunks) {
        if (chunks.isEmpty() || !Platform.PAPER.isAvailable()) {
            return CompletableFuture.completedFuture(null);
        }
        ArrayList<CompletableFuture<Chunk>> tasks = new ArrayList<CompletableFuture<Chunk>>();
        World world = chunks.iterator().next().getBukkitWorld();
        for (SimpleChunkLocation chunk : chunks) {
            tasks.add(PaperLib.getAsyncChunks().getChunkAtAsync(world, chunk.getX(), chunk.getZ(), true, false));
        }
        return CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0]));
    }
}

