/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.cache;

import java.time.Duration;
import java.util.function.Supplier;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u000eJ\r\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/kingdoms/utils/cache/CachedValue;", "T", "Ljava/util/function/Supplier;", "getter", "cacheTime", "Ljava/time/Duration;", "(Ljava/util/function/Supplier;Ljava/time/Duration;)V", "cached", "Ljava/lang/Object;", "lastChecked", "", "contains", "", "obj", "(Ljava/lang/Object;)Z", "get", "()Ljava/lang/Object;", "core"})
public final class CachedValue<T>
implements Supplier<T> {
    @NotNull
    private final Supplier<T> getter;
    @NotNull
    private final Duration cacheTime;
    private long lastChecked;
    @Nullable
    private T cached;

    public CachedValue(@NotNull Supplier<T> getter, @NotNull Duration cacheTime) {
        Intrinsics.checkNotNullParameter(getter, (String)"getter");
        Intrinsics.checkNotNullParameter((Object)cacheTime, (String)"cacheTime");
        this.getter = getter;
        this.cacheTime = cacheTime;
        this.lastChecked = System.currentTimeMillis();
        if (this.cacheTime.getSeconds() <= 5L) {
            throw new IllegalArgumentException("Any cache time under 5 seconds is not likely to help with performance: " + this.cacheTime.toMillis() + "ms");
        }
    }

    public final boolean contains(T obj) {
        return Intrinsics.areEqual(this.get(), obj);
    }

    @Override
    public T get() {
        long currentTime = System.currentTimeMillis();
        long diff = currentTime - this.lastChecked;
        if (this.cached == null || this.cacheTime.minusMillis(diff).isNegative()) {
            this.cached = this.getter.get();
            this.lastChecked = currentTime;
        }
        T t = this.cached;
        Intrinsics.checkNotNull(t);
        return t;
    }
}

