/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.config.adapters;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.kingdoms.config.ConfigAccessor;
import org.kingdoms.libs.snakeyaml.api.Load;
import org.kingdoms.libs.snakeyaml.api.LoadSettings;
import org.kingdoms.libs.snakeyaml.composer.Composer;
import org.kingdoms.libs.snakeyaml.nodes.MappingNode;
import org.kingdoms.libs.snakeyaml.validation.NodeValidator;
import org.kingdoms.libs.snakeyaml.validation.Validator;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.config.ConfigSection;

public interface YamlContainer {
    public ConfigSection getConfig();

    public ConfigAccessor accessor();

    public void saveConfig();

    default public boolean isLoaded() {
        return this.getConfig() != null;
    }

    public File getFile();

    default public void createFile() {
        try {
            this.getFile().createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static MappingNode getRootOf(String name, InputStream is) {
        LoadSettings settings = new LoadSettings();
        settings.setLabel(name);
        Load load2 = new Load(settings);
        Composer composer = load2.createComposer(is);
        MappingNode root = composer.getRoot();
        load2.construct(root);
        return root;
    }

    public static NodeValidator parseValidator(String label, String resourcePath) {
        InputStream is = Kingdoms.get().getResource(resourcePath);
        return YamlContainer.parseValidator(is, label);
    }

    public static NodeValidator parseValidator(InputStream is, String label) {
        LoadSettings settings = new LoadSettings();
        settings.setLabel(label + " Schema");
        Load load2 = new Load(settings);
        Composer composer = load2.createComposer(is);
        MappingNode schemaYml = composer.getRoot();
        load2.construct(schemaYml);
        return Validator.parseSchema(schemaYml);
    }

    public YamlContainer load();

    public void reload();
}

