/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.cooldown;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.kingdoms.utils.cooldown.AdvancedCooldownContainer;

public class ContainedCooldown<T, C> {
    private final Map<T, AdvancedCooldownContainer<C>> cooldowns;

    public ContainedCooldown() {
        this(new HashMap());
    }

    public ContainedCooldown(Map<T, AdvancedCooldownContainer<C>> cooldowns) {
        this.cooldowns = cooldowns;
    }

    public boolean add(T key, long time, C value) {
        return this.add(key, time, value, TimeUnit.MILLISECONDS);
    }

    public boolean add(T key, long time, C value, TimeUnit timeUnit) {
        if (this.isInCooldown(key)) {
            return false;
        }
        this.cooldowns.put(key, new AdvancedCooldownContainer<C>(timeUnit.toMillis(time), System.currentTimeMillis(), value));
        return true;
    }

    public boolean isInCooldown(T key) {
        return this.getTimeLeft(key) != 0L;
    }

    public C stop(T key) {
        AdvancedCooldownContainer<C> item = this.cooldowns.remove(key);
        return item == null ? null : (C)item.value;
    }

    public C get(T key) {
        AdvancedCooldownContainer<C> item = this.cooldowns.get(key);
        return item == null ? null : (C)item.value;
    }

    public long getTimeLeft(T key) {
        AdvancedCooldownContainer<C> cooldown = this.cooldowns.get(key);
        if (cooldown == null) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        long difference = now - cooldown.start;
        if (difference >= cooldown.time) {
            this.stop(key);
            return 0L;
        }
        return cooldown.time - difference;
    }
}

