/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.nbt;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.bukkit.entity.Entity;
import org.kingdoms.libs.xseries.ReflectionUtils;
import org.kingdoms.utils.nbt.NBTWrappers;

public final class EntityNBT {
    public static final MethodHandle ENTITY_HANDLE;
    public static final MethodHandle ENTITY_GET_TAG;
    public static final MethodHandle ENTITY_SET_TAG;

    public static NBTWrappers.NBTTagCompound getEntityTag(Entity entity) {
        try {
            Object nmsEntity = ENTITY_HANDLE.invoke(entity);
            NBTWrappers.NBTTagCompound compound = new NBTWrappers.NBTTagCompound();
            Object tag = compound.toNBT();
            ENTITY_GET_TAG.invoke(nmsEntity, tag);
            return NBTWrappers.NBTTagCompound.fromNBT(tag);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Class<?> craftEntity = ReflectionUtils.getCraftClass("entity.CraftEntity");
        Class<?> nmsEntity = ReflectionUtils.getNMSClass("Entity");
        Class<?> nbtCompound = ReflectionUtils.getNMSClass("NBTTagCompound");
        MethodHandle entityHandle = null;
        MethodHandle entityGetTag = null;
        Object entitySetTag = null;
        try {
            entityHandle = lookup.findVirtual(craftEntity, "getHandle", MethodType.methodType(nmsEntity));
            entityGetTag = lookup.findVirtual(nmsEntity, "c", MethodType.methodType(Boolean.TYPE, nbtCompound));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        ENTITY_HANDLE = entityHandle;
        ENTITY_GET_TAG = entityGetTag;
        ENTITY_SET_TAG = entitySetTag;
    }
}

