/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.volatilecode.virtual;

import io.lumine.mythic.api.MythicPlugin;
import io.lumine.mythic.api.MythicProvider;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.volatilecode.virtual.IPacketEntityRenderer;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntity;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntityRenderer;
import io.lumine.mythic.bukkit.utils.cache.DataTracker;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class PacketArmorStand<T extends PacketEntityRenderer>
extends PacketEntity {
    private DataTracker<ItemStack> headItem = DataTracker.of(null, false);
    private DataTracker<EulerAngle> rotation = DataTracker.of(null);
    private boolean small = false;
    private boolean upsideDown = false;

    public static PacketArmorStandBuilder create() {
        return new PacketArmorStandBuilder();
    }

    public PacketArmorStand(AbstractLocation location) {
        this(MythicProvider.get(), location);
    }

    public PacketArmorStand(AbstractLocation location, PacketArmorStandBuilder builder) {
        this(MythicProvider.get(), location);
        if (builder.headItem != null) {
            this.headItem.set(builder.headItem);
        }
        if (builder.small != null) {
            this.small = this.small;
        }
        if (builder.upsideDown != null) {
            this.upsideDown = this.upsideDown;
        }
    }

    public PacketArmorStand(MythicPlugin plugin, AbstractLocation location) {
        super(location);
        this.setRenderer(plugin.getVolatileCodeHandler().getWorldHandler().createVirtualArmorStandRenderer(this));
    }

    public void setHeadPose(EulerAngle rot) {
        if (this.rotation.set(rot)) {
            this.setDirty();
        }
    }

    public void setItem(ItemStack item) {
        if (this.headItem.set(item)) {
            this.setDirty();
        }
    }

    public DataTracker<ItemStack> getHeadItem() {
        return this.headItem;
    }

    public DataTracker<EulerAngle> getRotation() {
        return this.rotation;
    }

    public boolean isSmall() {
        return this.small;
    }

    public boolean isUpsideDown() {
        return this.upsideDown;
    }

    public static class PacketArmorStandBuilder {
        private ItemStack headItem;
        private Boolean small;
        private Boolean upsideDown;

        public PacketArmorStand build(AbstractLocation location) {
            return new PacketArmorStand(location, this);
        }

        public ItemStack headItem() {
            return this.headItem;
        }

        public Boolean small() {
            return this.small;
        }

        public Boolean upsideDown() {
            return this.upsideDown;
        }

        public PacketArmorStandBuilder headItem(ItemStack headItem) {
            this.headItem = headItem;
            return this;
        }

        public PacketArmorStandBuilder small(Boolean small) {
            this.small = small;
            return this;
        }

        public PacketArmorStandBuilder upsideDown(Boolean upsideDown) {
            this.upsideDown = upsideDown;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PacketArmorStandBuilder)) {
                return false;
            }
            PacketArmorStandBuilder other = (PacketArmorStandBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$small = this.small();
            Boolean other$small = other.small();
            if (this$small == null ? other$small != null : !((Object)this$small).equals(other$small)) {
                return false;
            }
            Boolean this$upsideDown = this.upsideDown();
            Boolean other$upsideDown = other.upsideDown();
            if (this$upsideDown == null ? other$upsideDown != null : !((Object)this$upsideDown).equals(other$upsideDown)) {
                return false;
            }
            ItemStack this$headItem = this.headItem();
            ItemStack other$headItem = other.headItem();
            return !(this$headItem == null ? other$headItem != null : !this$headItem.equals(other$headItem));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PacketArmorStandBuilder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $small = this.small();
            result = result * 59 + ($small == null ? 43 : ((Object)$small).hashCode());
            Boolean $upsideDown = this.upsideDown();
            result = result * 59 + ($upsideDown == null ? 43 : ((Object)$upsideDown).hashCode());
            ItemStack $headItem = this.headItem();
            result = result * 59 + ($headItem == null ? 43 : $headItem.hashCode());
            return result;
        }

        public String toString() {
            return "PacketArmorStand.PacketArmorStandBuilder(headItem=" + this.headItem() + ", small=" + this.small() + ", upsideDown=" + this.upsideDown() + ")";
        }
    }

    public static interface PacketArmorStandEntityRenderer
    extends IPacketEntityRenderer {
    }
}

