/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.volatilecode.virtual;

import io.lumine.mythic.api.MythicPlugin;
import io.lumine.mythic.api.MythicProvider;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.volatilecode.virtual.IPacketEntityRenderer;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntity;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntityRenderer;
import io.lumine.mythic.bukkit.utils.cache.DataTracker;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import org.bukkit.Material;
import org.bukkit.entity.Display;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.ItemStack;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PacketItemDisplay<T extends PacketEntityRenderer>
extends PacketEntity {
    private DataTracker<Integer> interpolationDelay = DataTracker.of(0);
    private DataTracker<Integer> interpolationDuration = DataTracker.of(1);
    private DataTracker<Float> viewRange = DataTracker.of(Float.valueOf(4096.0f));
    private DataTracker<Float> height = DataTracker.of(Float.valueOf(4096.0f));
    private DataTracker<Float> width = DataTracker.of(Float.valueOf(4096.0f));
    private DataTracker<Display.Billboard> billboard = DataTracker.of(Display.Billboard.FIXED);
    private DataTracker<Integer> brightness = DataTracker.of(-1, false);
    private DataTracker<Vector3f> scale = DataTracker.of(new Vector3f(1.0f, 1.0f, 1.0f));
    private DataTracker<Vector3f> translation = DataTracker.of(new Vector3f(0.0f, 0.0f, 0.0f));
    private DataTracker<Quaternionf> rotationLeft = DataTracker.of(new Quaternionf(), false);
    private DataTracker<Quaternionf> rotationRight = DataTracker.of(new Quaternionf(), false);
    private DataTracker<ItemStack> item = DataTracker.of(new ItemStack(Material.AIR));
    private DataTracker<ItemDisplay.ItemDisplayTransform> displayTransform = DataTracker.of(ItemDisplay.ItemDisplayTransform.HEAD);
    private static final float DEG2RAD = (float)Math.PI / 180;

    public static PacketItemDisplayBuilder create() {
        return new PacketItemDisplayBuilder();
    }

    public PacketItemDisplay(AbstractLocation location) {
        this(MythicProvider.get(), location);
    }

    public PacketItemDisplay(AbstractLocation location, PacketItemDisplayBuilder builder) {
        this(MythicProvider.get(), location);
        if (builder.interpolationDelay != null) {
            this.interpolationDelay.set(builder.interpolationDelay);
        }
        if (builder.interpolationDuration != null) {
            this.interpolationDuration.set(builder.interpolationDuration);
        }
        if (builder.height != null) {
            this.height.set(builder.height);
        }
        if (builder.width != null) {
            this.width.set(builder.width);
        }
        if (builder.billboard != null) {
            this.billboard.set(builder.billboard);
        }
        if (builder.brightness != null) {
            this.brightness.set(builder.brightness);
        }
        if (builder.scale != null) {
            this.scale.set(builder.scale);
        }
        if (builder.yOffset != null) {
            this.translation.set(new Vector3f(0.0f, builder.yOffset.floatValue(), 0.0f));
        }
        if (builder.item != null) {
            this.item.set(builder.item);
        }
    }

    public PacketItemDisplay(MythicPlugin plugin, AbstractLocation location) {
        super(location);
        this.setRenderer(plugin.getVolatileCodeHandler().getWorldHandler().createVirtualDisplayItemEntityRenderer(this));
    }

    public void setItem(ItemStack item) {
        if (this.item.set(item)) {
            this.setDirty();
        }
    }

    public void setRotation(float yaw, float pitch) {
        Quaternionf q = new Quaternionf().rotateY(-yaw * ((float)Math.PI / 180)).rotateX(-pitch * ((float)Math.PI / 180));
        if (ServerVersion.isAfter(MinecraftVersions.v1_19_4)) {
            q.rotateY((float)Math.PI);
        }
        if (this.rotationLeft.set(q)) {
            this.setDirty();
        }
    }

    public void setRotationTransformation(float x, float y, float z) {
        if (this.rotationRight.set(new Quaternionf().rotationXYZ(x, y, z))) {
            this.setDirty();
        }
    }

    public void setTranslationTransformation(float x, float y, float z) {
        if (this.translation.set(new Vector3f(x, y, z))) {
            this.setDirty();
        }
    }

    public void setScale(AbstractVector scale) {
        if (this.scale.set(scale.toVector3f())) {
            this.setDirty();
        }
    }

    public void setBrightness(Display.Brightness brightness) {
        int brightnessBlock = brightness.getBlockLight();
        int brightnessSky = brightness.getSkyLight();
        this.brightness.set(brightnessBlock << 4 | brightnessSky << 20);
        this.setDirty();
    }

    public DataTracker<Integer> getInterpolationDelay() {
        return this.interpolationDelay;
    }

    public DataTracker<Integer> getInterpolationDuration() {
        return this.interpolationDuration;
    }

    public DataTracker<Float> getViewRange() {
        return this.viewRange;
    }

    public DataTracker<Float> getHeight() {
        return this.height;
    }

    public DataTracker<Float> getWidth() {
        return this.width;
    }

    public DataTracker<Display.Billboard> getBillboard() {
        return this.billboard;
    }

    public DataTracker<Integer> getBrightness() {
        return this.brightness;
    }

    public DataTracker<Vector3f> getScale() {
        return this.scale;
    }

    public DataTracker<Vector3f> getTranslation() {
        return this.translation;
    }

    public DataTracker<Quaternionf> getRotationLeft() {
        return this.rotationLeft;
    }

    public DataTracker<Quaternionf> getRotationRight() {
        return this.rotationRight;
    }

    public DataTracker<ItemStack> getItem() {
        return this.item;
    }

    public DataTracker<ItemDisplay.ItemDisplayTransform> getDisplayTransform() {
        return this.displayTransform;
    }

    public static class PacketItemDisplayBuilder {
        private Integer interpolationDelay;
        private Integer interpolationDuration;
        private Float viewRange;
        private Float height;
        private Float width;
        private Float yOffset;
        private Display.Billboard billboard;
        private Integer brightness;
        private Vector3f scale;
        private ItemStack item;

        public PacketItemDisplayBuilder scale(AbstractVector scale) {
            this.scale = new Vector3f((float)scale.getX(), (float)scale.getY(), (float)scale.getZ());
            return this;
        }

        public PacketItemDisplayBuilder brightness(int brightness) {
            this.brightness = brightness;
            return this;
        }

        public PacketItemDisplayBuilder billboard(String billboarding) {
            this.billboard = Display.Billboard.valueOf((String)billboarding.toUpperCase());
            return this;
        }

        public PacketItemDisplay build(AbstractLocation location) {
            return new PacketItemDisplay(location, this);
        }

        public Integer interpolationDelay() {
            return this.interpolationDelay;
        }

        public Integer interpolationDuration() {
            return this.interpolationDuration;
        }

        public Float viewRange() {
            return this.viewRange;
        }

        public Float height() {
            return this.height;
        }

        public Float width() {
            return this.width;
        }

        public Float yOffset() {
            return this.yOffset;
        }

        public Display.Billboard billboard() {
            return this.billboard;
        }

        public Integer brightness() {
            return this.brightness;
        }

        public Vector3f scale() {
            return this.scale;
        }

        public ItemStack item() {
            return this.item;
        }

        public PacketItemDisplayBuilder interpolationDelay(Integer interpolationDelay) {
            this.interpolationDelay = interpolationDelay;
            return this;
        }

        public PacketItemDisplayBuilder interpolationDuration(Integer interpolationDuration) {
            this.interpolationDuration = interpolationDuration;
            return this;
        }

        public PacketItemDisplayBuilder viewRange(Float viewRange) {
            this.viewRange = viewRange;
            return this;
        }

        public PacketItemDisplayBuilder height(Float height) {
            this.height = height;
            return this;
        }

        public PacketItemDisplayBuilder width(Float width) {
            this.width = width;
            return this;
        }

        public PacketItemDisplayBuilder yOffset(Float yOffset) {
            this.yOffset = yOffset;
            return this;
        }

        public PacketItemDisplayBuilder item(ItemStack item) {
            this.item = item;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PacketItemDisplayBuilder)) {
                return false;
            }
            PacketItemDisplayBuilder other = (PacketItemDisplayBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$interpolationDelay = this.interpolationDelay();
            Integer other$interpolationDelay = other.interpolationDelay();
            if (this$interpolationDelay == null ? other$interpolationDelay != null : !((Object)this$interpolationDelay).equals(other$interpolationDelay)) {
                return false;
            }
            Integer this$interpolationDuration = this.interpolationDuration();
            Integer other$interpolationDuration = other.interpolationDuration();
            if (this$interpolationDuration == null ? other$interpolationDuration != null : !((Object)this$interpolationDuration).equals(other$interpolationDuration)) {
                return false;
            }
            Float this$viewRange = this.viewRange();
            Float other$viewRange = other.viewRange();
            if (this$viewRange == null ? other$viewRange != null : !((Object)this$viewRange).equals(other$viewRange)) {
                return false;
            }
            Float this$height = this.height();
            Float other$height = other.height();
            if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
                return false;
            }
            Float this$width = this.width();
            Float other$width = other.width();
            if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
                return false;
            }
            Float this$yOffset = this.yOffset();
            Float other$yOffset = other.yOffset();
            if (this$yOffset == null ? other$yOffset != null : !((Object)this$yOffset).equals(other$yOffset)) {
                return false;
            }
            Integer this$brightness = this.brightness();
            Integer other$brightness = other.brightness();
            if (this$brightness == null ? other$brightness != null : !((Object)this$brightness).equals(other$brightness)) {
                return false;
            }
            Display.Billboard this$billboard = this.billboard();
            Display.Billboard other$billboard = other.billboard();
            if (this$billboard == null ? other$billboard != null : !this$billboard.equals(other$billboard)) {
                return false;
            }
            Vector3f this$scale = this.scale();
            Vector3f other$scale = other.scale();
            if (this$scale == null ? other$scale != null : !this$scale.equals(other$scale)) {
                return false;
            }
            ItemStack this$item = this.item();
            ItemStack other$item = other.item();
            return !(this$item == null ? other$item != null : !this$item.equals(other$item));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PacketItemDisplayBuilder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $interpolationDelay = this.interpolationDelay();
            result = result * 59 + ($interpolationDelay == null ? 43 : ((Object)$interpolationDelay).hashCode());
            Integer $interpolationDuration = this.interpolationDuration();
            result = result * 59 + ($interpolationDuration == null ? 43 : ((Object)$interpolationDuration).hashCode());
            Float $viewRange = this.viewRange();
            result = result * 59 + ($viewRange == null ? 43 : ((Object)$viewRange).hashCode());
            Float $height = this.height();
            result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
            Float $width = this.width();
            result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
            Float $yOffset = this.yOffset();
            result = result * 59 + ($yOffset == null ? 43 : ((Object)$yOffset).hashCode());
            Integer $brightness = this.brightness();
            result = result * 59 + ($brightness == null ? 43 : ((Object)$brightness).hashCode());
            Display.Billboard $billboard = this.billboard();
            result = result * 59 + ($billboard == null ? 43 : $billboard.hashCode());
            Vector3f $scale = this.scale();
            result = result * 59 + ($scale == null ? 43 : $scale.hashCode());
            ItemStack $item = this.item();
            result = result * 59 + ($item == null ? 43 : $item.hashCode());
            return result;
        }

        public String toString() {
            return "PacketItemDisplay.PacketItemDisplayBuilder(interpolationDelay=" + this.interpolationDelay() + ", interpolationDuration=" + this.interpolationDuration() + ", viewRange=" + this.viewRange() + ", height=" + this.height() + ", width=" + this.width() + ", yOffset=" + this.yOffset() + ", billboard=" + this.billboard() + ", brightness=" + this.brightness() + ", scale=" + this.scale() + ", item=" + this.item() + ")";
        }
    }

    public static interface PacketItemDisplayEntityRenderer
    extends IPacketEntityRenderer {
    }
}

