/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters;

import com.destroystokyo.paper.event.entity.CreeperIgniteEvent;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.drops.ICommandDrop;
import io.lumine.mythic.api.drops.IDrop;
import io.lumine.mythic.api.drops.IIntangibleDrop;
import io.lumine.mythic.api.drops.IItemDrop;
import io.lumine.mythic.api.drops.ILocationDrop;
import io.lumine.mythic.api.drops.IMessagingDrop;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitTriggerMetadata;
import io.lumine.mythic.bukkit.entities.BukkitCreeper;
import io.lumine.mythic.bukkit.entities.BukkitTNT;
import io.lumine.mythic.bukkit.entities.properties.TameableEntityType;
import io.lumine.mythic.bukkit.entities.properties.TameableProperty;
import io.lumine.mythic.bukkit.events.MythicMobDeathEvent;
import io.lumine.mythic.bukkit.events.MythicMobInteractEvent;
import io.lumine.mythic.bukkit.events.MythicMobLootDropEvent;
import io.lumine.mythic.bukkit.listeners.triggers.DamageTriggerListeners;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.plugin.PluginModule;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.drops.Drop;
import io.lumine.mythic.core.drops.DropMetadataImpl;
import io.lumine.mythic.core.drops.LootBag;
import io.lumine.mythic.core.drops.droppables.CustomDrop;
import io.lumine.mythic.core.drops.droppables.ExperienceDrop;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.EventExecutor;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.TriggeredSkill;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.utils.adventure.PaperHelper;
import io.papermc.paper.event.player.PlayerTradeEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketEntityEvent;
import org.bukkit.event.player.PlayerBucketEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;

public class BukkitSkillTriggers
extends PluginModule<MythicBukkit>
implements Listener {
    private final DamageTriggerListeners damageTriggerListeners;

    public BukkitSkillTriggers(MythicBukkit plugin) {
        super(plugin);
        this.damageTriggerListeners = new DamageTriggerListeners(plugin);
    }

    @Override
    public void load(MythicBukkit plugin) {
        Events.subscribe(EntityShootBowEvent.class).filter(event -> !event.isCancelled()).handler(this::onShootTrigger).bindWith(this);
        Events.subscribe(ProjectileLaunchEvent.class).filter(event -> !event.isCancelled()).filter(event -> event.getEntity().getShooter() != null).filter(event -> event.getEntity().getShooter() instanceof Entity).filter(event -> plugin.getMobManager().isActiveMob(((Entity)event.getEntity().getShooter()).getUniqueId())).handler(this::onShootProjectileTrigger).bindWith(this);
        Events.subscribe(EntityDeathEvent.class, EventPriority.HIGHEST).handler(this::onDeathTrigger).bindWith(this);
        Events.subscribe(CreeperPowerEvent.class).handler(this::onCreeperChargedTrigger).bindWith(this);
        Events.subscribe(EntityBreedEvent.class).handler(this::onEntityBreed).bindWith(this);
        Events.subscribe(EntityPortalEvent.class).handler(this::onWorldChange).bindWith(this);
        Events.subscribe(PlayerBucketEntityEvent.class).handler(this::onBucketEntityFill).bindWith(this);
        Events.subscribe(PlayerBucketFillEvent.class).handler(this::onBucketFill).bindWith(this);
        Events.subscribe(PlayerBucketEmptyEvent.class).handler(this::onBucketFill).bindWith(this);
        if (ServerVersion.isPaper()) {
            try {
                if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_17)) {
                    Events.subscribe(CreeperIgniteEvent.class).handler(this::onCreeperPrimeTrigger).bindWith(this);
                }
                Events.subscribe(PlayerTradeEvent.class).handler(this::onMerchantTrade).bindWith(this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void unload() {
    }

    protected EventExecutor eventBus() {
        return ((MythicBukkit)this.getPlugin()).getSkillManager().getEventBus();
    }

    void onBucketEntityFill(PlayerBucketEntityEvent event) {
        ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMob(event.getEntity().getUniqueId()).ifPresent(mob -> {
            TriggeredSkill ts = new TriggeredSkill(SkillTriggers.BUCKET, (ActiveMob)mob, mob.getEntity(), false);
            if (ts.getCancelled()) {
                event.setCancelled(true);
                event.getPlayer().updateInventory();
            }
        });
    }

    void onBucketFill(PlayerBucketEvent event) {
        Location pos;
        Iterator entityIterator;
        ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMob(event.getPlayer().getUniqueId()).ifPresent(mob -> {
            TriggeredSkill ts = new TriggeredSkill(SkillTriggers.BUCKET, (ActiveMob)mob, mob.getEntity(), false);
            if (ts.getCancelled()) {
                event.setCancelled(true);
                event.getPlayer().updateInventory();
            }
        });
        Entity targetEntity = event.getPlayer().getTargetEntity(5, true);
        if (targetEntity == null && (entityIterator = (pos = event.getBlock().getLocation()).getWorld().getNearbyEntities(pos, 3.0, 3.0, 3.0, entity -> entity.getType() == EntityType.COW || entity.getType() == EntityType.MUSHROOM_COW).iterator()).hasNext()) {
            targetEntity = (Entity)entityIterator.next();
        }
        if (targetEntity != null) {
            ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMob(targetEntity.getUniqueId()).ifPresent(mob -> {
                AbstractPlayer player = BukkitAdapter.adapt(event.getPlayer());
                TriggeredSkill ts = new TriggeredSkill(SkillTriggers.BUCKET, (ActiveMob)mob, player, false);
                if (ts.getCancelled()) {
                    event.setCancelled(true);
                    event.getPlayer().updateInventory();
                }
            });
        }
    }

    void onWorldChange(EntityPortalEvent event) {
        ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMob(event.getEntity().getUniqueId()).ifPresent(mob -> {
            if (event.getTo() == null) {
                return;
            }
            World destinationWorld = event.getTo().getWorld();
            TriggeredSkill ts = new TriggeredSkill(SkillTriggers.CHANGE_WORLD, (ActiveMob)mob, mob.getEntity(), true, meta -> meta.getVariables().putString("world", destinationWorld.getName()));
            if (ts.getCancelled()) {
                event.setCancelled(true);
            }
        });
    }

    private void onMerchantTrade(PlayerTradeEvent event) {
        ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMob(event.getVillager().getUniqueId()).ifPresent(am -> {
            TriggeredSkill ts = new TriggeredSkill(SkillTriggers.TRADE, (ActiveMob)am, BukkitAdapter.adapt(event.getPlayer()));
            if (ts.getCancelled()) {
                event.setCancelled(true);
            }
        });
    }

    public void onEntityBreed(EntityBreedEvent event) {
        TriggeredSkill ts;
        AbstractEntity child = BukkitAdapter.adapt((Entity)event.getEntity());
        AbstractEntity mother = BukkitAdapter.adapt((Entity)event.getMother());
        AbstractEntity father = BukkitAdapter.adapt((Entity)event.getFather());
        AbstractEntity breeder = BukkitAdapter.adapt((Entity)event.getBreeder());
        if (((MythicBukkit)this.plugin).getMobManager().isActiveMob(mother)) {
            ActiveMob aMother = ((MythicBukkit)this.plugin).getMobManager().getMythicMobInstance(mother);
            if (aMother == null) {
                return;
            }
            ts = new TriggeredSkill(SkillTriggers.BREED, aMother, breeder, false, meta -> {
                meta.getVariables().putObject("father", father);
                meta.getVariables().putObject("child", child);
            });
            if (ts.getCancelled()) {
                event.setCancelled(true);
            }
        }
        if (((MythicBukkit)this.plugin).getMobManager().isActiveMob(father)) {
            ActiveMob aFather = ((MythicBukkit)this.plugin).getMobManager().getMythicMobInstance(father);
            if (aFather == null) {
                return;
            }
            ts = new TriggeredSkill(SkillTriggers.BREED, aFather, breeder, false, meta -> {
                meta.getVariables().putObject("mother", mother);
                meta.getVariables().putObject("child", child);
            });
            if (ts.getCancelled()) {
                event.setCancelled(true);
            }
        }
    }

    public void onCreeperPrimeTrigger(CreeperIgniteEvent event) {
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "CreeperIgniteEvent fired", new Object[0]);
        Creeper l = event.getEntity();
        if (!((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(l.getUniqueId())) {
            return;
        }
        ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)l));
        TriggeredSkill ts = new TriggeredSkill(SkillTriggers.PRIME, am, BukkitAdapter.adapt((Entity)l), true);
        if (ts.getCancelled()) {
            event.setCancelled(true);
        }
    }

    public void onCreeperChargedTrigger(CreeperPowerEvent event) {
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "CreeperPowerEvent fired", new Object[0]);
        Creeper l = event.getEntity();
        if (!((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(l.getUniqueId())) {
            return;
        }
        ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)l));
        TriggeredSkill ts = new TriggeredSkill(SkillTriggers.CREEPER_CHARGE, am, BukkitAdapter.adapt((Entity)l), true);
        if (ts.getCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInteractTrigger(PlayerInteractAtEntityEvent e) {
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "PlayerInteractAtEntityEvent fired", new Object[0]);
        Entity clickedEntity = e.getRightClicked();
        if (!MythicBukkit.inst().getMobManager().isActiveMob(clickedEntity.getUniqueId())) {
            return;
        }
        ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMob(clickedEntity.getUniqueId()).get();
        Player player = e.getPlayer();
        if (e.getHand() == EquipmentSlot.HAND) {
            TriggeredSkill ts;
            MythicMobInteractEvent event = new MythicMobInteractEvent(e.getPlayer(), am);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (!(event.isCancelled() || !(ts = new TriggeredSkill(SkillTriggers.INTERACT, am, BukkitAdapter.adapt(player), true)).getCancelled() && am.getType().getIsInteractable())) {
                e.setCancelled(true);
                if (e.getRightClicked().getType().equals((Object)EntityType.VILLAGER)) {
                    Villager v = (Villager)e.getRightClicked();
                    if (player.getOpenInventory().getTopInventory().equals(v.getInventory())) {
                        player.getOpenInventory().close();
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onTameTrigger(EntityTameEvent event) {
        TameableProperty prop;
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "EntityTameEvent fired", new Object[0]);
        LivingEntity entity = event.getEntity();
        if (!((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(entity.getUniqueId())) {
            return;
        }
        Player player = (Player)event.getOwner();
        ActiveMob am = MythicBukkit.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)entity));
        if (am.getType().getMythicEntity() instanceof TameableEntityType && !(prop = ((TameableEntityType)((Object)am.getType().getMythicEntity())).getTameableProperty()).isTameable()) {
            event.setCancelled(true);
            Text.sendMessage((CommandSender)player, "<red>That mob cannot be tamed!");
            player.playSound(player.getLocation(), "entity.villager.no", 1.0f, 1.0f);
            return;
        }
        TriggeredSkill ts = new TriggeredSkill(SkillTriggers.TAME, am, BukkitAdapter.adapt(player));
        if (ts.getCancelled()) {
            event.setCancelled(true);
            return;
        }
        Schedulers.sync().runLater(() -> {
            am.getType().applyMobOptions(am, am.getLevel());
            am.getType().applyMobVolatileOptions(am);
        }, 5L);
    }

    public void onDeathTrigger(EntityDeathEvent event) {
        boolean dropLoot = true;
        AbstractEntity killedEntity = BukkitAdapter.adapt((Entity)event.getEntity());
        ActiveMob am = MythicBukkit.inst().getMobManager().getMythicMobInstance(killedEntity);
        if (am != null) {
            MythicMob mm4 = am.getType();
            if (am.isDead()) {
                return;
            }
            LivingEntity killer = this.getKiller(event);
            AbstractEntity aKiller = killer == null ? null : BukkitAdapter.adapt((Entity)killer);
            TriggeredSkill ts = new TriggeredSkill(SkillTriggers.DEATH, am, aKiller, false);
            if (ts.getCancelled() && ServerVersion.isPaper()) {
                event.setReviveHealth(am.getType().getReviveHealth(am));
                event.setCancelled(true);
                ts.setCancelled();
                return;
            }
            if (killer != null && !(killer instanceof Player) && MythicBukkit.inst().getMobManager().isActiveMob(killer.getUniqueId())) {
                ActiveMob amkiller = MythicBukkit.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)killer));
                if (!killedEntity.isPlayer() && amkiller.getType().getPreventMobKillDrops().booleanValue()) {
                    event.getDrops().clear();
                    dropLoot = false;
                }
            }
            if (mm4.getPreventOtherDrops().booleanValue()) {
                event.getDrops().clear();
                event.setDroppedExp(0);
            }
            DropMetadataImpl metadata = new DropMetadataImpl(am, aKiller);
            LootBag lootBag = mm4.getDropTable().generate(metadata);
            MythicMobLootDropEvent mythicLootEvent = new MythicMobLootDropEvent(am, killer, lootBag);
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Calling MythicMobLootDropEvent for " + am.getType().getInternalName(), new Object[0]);
            Bukkit.getServer().getPluginManager().callEvent((Event)mythicLootEvent);
            int experience = 0;
            if (dropLoot) {
                HashMap<IMessagingDrop, Double> messagingDrops = new HashMap<IMessagingDrop, Double>();
                for (Drop drop : lootBag.getDrops()) {
                    IDrop drop2;
                    double amount = drop.getAmount();
                    if (drop instanceof CustomDrop) {
                        if (((CustomDrop)drop).getDrop().isEmpty()) continue;
                        drop2 = ((CustomDrop)drop).getDrop().get();
                    } else {
                        drop2 = drop;
                    }
                    if (drop2 instanceof IItemDrop) {
                        event.getDrops().add(BukkitAdapter.adapt(((IItemDrop)drop2).getDrop(metadata, amount)));
                    } else if (drop2 instanceof ExperienceDrop) {
                        experience = (int)((double)experience + amount);
                    } else if (drop2 instanceof IIntangibleDrop) {
                        if (aKiller != null && aKiller.isPlayer()) {
                            ((IIntangibleDrop)drop2).giveDrop(aKiller.asPlayer(), metadata, amount);
                        }
                    } else if (drop2 instanceof ILocationDrop) {
                        ((ILocationDrop)drop2).drop(killedEntity.getLocation(), metadata, amount);
                    } else if (drop2 instanceof ICommandDrop) {
                        metadata.setAmount((int)amount);
                        if (aKiller != null && aKiller.isPlayer()) {
                            ((ICommandDrop)drop2).dispatchCommand(aKiller.asPlayer(), metadata, amount);
                        } else {
                            ((ICommandDrop)drop2).dispatchCommand(null, metadata, amount);
                        }
                    }
                    if (!(drop2 instanceof IMessagingDrop)) continue;
                    messagingDrops.merge((IMessagingDrop)((Object)drop2), amount, (n, o) -> n + o);
                }
                if (aKiller != null && aKiller.isPlayer() && messagingDrops.size() > 0) {
                    for (Map.Entry entry : messagingDrops.entrySet()) {
                        String message = ((IMessagingDrop)entry.getKey()).getRewardMessage(metadata, (Double)entry.getValue());
                        if (message == null) continue;
                        aKiller.asPlayer().sendMessage(message);
                    }
                }
                if (experience > 0) {
                    event.setDroppedExp(experience);
                }
            } else {
                event.setDroppedExp(0);
                event.getDrops().clear();
            }
            MythicMobDeathEvent mythicDeathEvent = new MythicMobDeathEvent(am, killer, event.getDrops());
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Calling MythicMobDeathEvent for " + am.getType().getInternalName(), new Object[0]);
            Bukkit.getServer().getPluginManager().callEvent((Event)mythicDeathEvent);
            am.setDead();
        } else {
            LivingEntity killerLE = this.getKiller(event);
            if (killerLE != null && MythicBukkit.inst().getMobManager().isActiveMob(killerLE.getUniqueId())) {
                ActiveMob amkiller = MythicBukkit.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)killerLE));
                if (!killedEntity.isPlayer() && amkiller.getType().getPreventMobKillDrops().booleanValue()) {
                    event.getDrops().clear();
                    event.setDroppedExp(0);
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Killed by entity with PreventKillDrops: true, cancelling drops!", new Object[0]);
                }
            }
        }
        MythicBukkit.inst().getMobManager().getActiveMobsInCombat().forEach(mob -> {
            if (mob.getEntity().isValid() && mob.getType().usesThreatTable()) {
                mob.getThreatTable().observeDeath(killedEntity);
            }
        });
    }

    public void onShootTrigger(EntityShootBowEvent event) {
        LivingEntity shooter = event.getEntity();
        if (shooter instanceof Player) {
            return;
        }
        if (((MythicBukkit)this.getPlugin()).getMobManager().isIgnoredEntity(shooter.getUniqueId())) {
            return;
        }
        if (!((MythicBukkit)this.getPlugin()).getMobManager().isMythicMob((Entity)shooter)) {
            return;
        }
        ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance((Entity)shooter);
        if (am != null) {
            MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "MythicMob {0} shot a projectile!", am.getType().getInternalName());
            TriggeredSkill ts = new TriggeredSkill(SkillTriggers.SHOOT, am, BukkitAdapter.adapt((Entity)shooter), false, meta -> BukkitTriggerMetadata.apply(meta, event));
            if (ts.getCancelled()) {
                event.setCancelled(true);
            }
        }
    }

    public void onShootProjectileTrigger(ProjectileLaunchEvent event) {
        Projectile projectile = event.getEntity();
        EntityType projType = event.getEntityType();
        Entity shooter = (Entity)event.getEntity().getShooter();
        ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(BukkitAdapter.adapt(shooter));
        switch (shooter.getType()) {
            case BLAZE: {
                if (projType == EntityType.SMALL_FIREBALL) break;
                return;
            }
            case ENDER_DRAGON: {
                if (projType == EntityType.DRAGON_FIREBALL) break;
                return;
            }
            case GHAST: {
                if (projType == EntityType.FIREBALL) break;
                return;
            }
            case LLAMA: {
                if (projType == EntityType.LLAMA_SPIT) break;
                return;
            }
            case SNOWMAN: {
                if (projType == EntityType.SNOWBALL) break;
                return;
            }
            case WITHER: {
                if (projType == EntityType.WITHER_SKULL) break;
                return;
            }
            case DROWNED: {
                if (projType == EntityType.TRIDENT) break;
                return;
            }
            default: {
                return;
            }
        }
        if (am != null) {
            MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "MythicMob {0} shot a projectile!", am.getType().getInternalName());
            TriggeredSkill ts = new TriggeredSkill(SkillTriggers.SHOOT, am, BukkitAdapter.adapt(shooter), false, meta -> BukkitTriggerMetadata.apply(meta, event));
            if (ts.getCancelled()) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChangeWorld(PlayerChangedWorldEvent event) {
        AbstractPlayer entity = BukkitAdapter.adapt(event.getPlayer());
        MythicBukkit.inst().getMobManager().getActiveMobsInCombat().forEach(mob -> {
            if (mob.getEntity().isValid() && mob.getType().usesThreatTable()) {
                mob.getThreatTable().observeChangeWorld(entity);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerKillTrigger(PlayerDeathEvent event) {
        ProjectileSource ps;
        EntityDamageEvent entityDamageEvent;
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "PlayerDeathEvent fired", new Object[0]);
        Player p = event.getEntity();
        Player k = p.getKiller();
        AbstractPlayer player = BukkitAdapter.adapt(p);
        if (((MythicBukkit)this.getPlugin()).getConfiguration().getKillMessagePrefix() != null && event.getDeathMessage() != null) {
            if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_16_4)) {
                event.deathMessage(PaperHelper.parse(((MythicBukkit)this.getPlugin()).getConfiguration().getKillMessagePrefix()).append(event.deathMessage()));
            } else {
                event.setDeathMessage(((MythicBukkit)this.getPlugin()).getConfiguration().getKillMessagePrefix() + event.getDeathMessage());
            }
        }
        if (k == null && (entityDamageEvent = event.getEntity().getLastDamageCause()) != null && !entityDamageEvent.isCancelled() && entityDamageEvent instanceof EntityDamageByEntityEvent) {
            k = ((EntityDamageByEntityEvent)entityDamageEvent).getDamager();
        }
        if (k instanceof LivingEntity) {
            LivingEntity killer = (LivingEntity)k;
            ActiveMob am = MythicBukkit.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)killer));
            if (am != null) {
                TriggeredSkill ts = new TriggeredSkill(SkillTriggers.KILLPLAYER, am, player);
                am.incrementPlayerKills();
                if (am.getType().hasKillMessages()) {
                    PlaceholderString km4 = am.getType().getKillMessage();
                    event.setDeathMessage(km4.get((PlaceholderMeta)ts.getData(), player));
                }
            }
        } else if (k instanceof Projectile && (ps = ((Projectile)k).getShooter()) instanceof LivingEntity) {
            LivingEntity shooter = (LivingEntity)ps;
            ActiveMob am = MythicBukkit.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)shooter));
            if (am != null) {
                TriggeredSkill ts = new TriggeredSkill(SkillTriggers.KILLPLAYER, am, player);
                am.incrementPlayerKills();
                if (am.getType().hasKillMessages()) {
                    PlaceholderString km5 = am.getType().getKillMessage();
                    event.setDeathMessage(km5.get((PlaceholderMeta)ts.getData(), player));
                }
            }
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent e) {
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "EntityExplodeEvent fired", new Object[0]);
        if (e.getEntity() == null) {
            return;
        }
        if (MythicBukkit.inst().getMobManager().isActiveMob(e.getEntity().getUniqueId())) {
            ActiveMob am = MythicBukkit.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt(e.getEntity()));
            if (am.getType().getMythicEntity() instanceof BukkitCreeper) {
                LivingEntity l = (LivingEntity)e.getEntity();
                if (((BukkitCreeper)am.getType().getMythicEntity()).preventSuicide()) {
                    MythicLogger.debug(MythicLogger.DebugLevel.INFO, "MythicCreeper has preventSuicide == true, cloning creeper...", new Object[0]);
                    ActiveMob replacement = am.getType().spawn(am.getEntity().getLocation(), am.getLevel(), SpawnReason.OTHER);
                    LivingEntity ll = (LivingEntity)BukkitAdapter.adapt(replacement.getEntity());
                    ll.setMaxHealth(l.getMaxHealth());
                    ll.setHealth(l.getHealth());
                    if (l.getPassenger() != null) {
                        ll.setPassenger(l.getPassenger());
                    }
                    if (l.getVehicle() != null) {
                        l.getVehicle().setPassenger((Entity)ll);
                    }
                    Collection pe = l.getActivePotionEffects();
                    for (PotionEffect p : pe) {
                        ll.addPotionEffect(p);
                    }
                    ActiveMob am2 = MythicBukkit.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)ll));
                    if (am2 == null) {
                        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "! Something prevented Creeper from cloning! PreventSuicide failed :(", new Object[0]);
                        return;
                    }
                    am2.setStance(am.getStance());
                    am2.importPlayerKills(am.getPlayerKills());
                    am2.importThreatTable(am.getThreatTable());
                    TriggeredSkill ts = new TriggeredSkill(SkillTriggers.EXPLODE, am, null);
                    if (ts.getCancelled()) {
                        e.setCancelled(true);
                    }
                } else {
                    TriggeredSkill ts = new TriggeredSkill(SkillTriggers.EXPLODE, am, null);
                    if (ts.getCancelled()) {
                        e.setCancelled(true);
                    }
                }
            } else if (am.getType().getMythicEntity() instanceof BukkitTNT) {
                TriggeredSkill ts = new TriggeredSkill(SkillTriggers.EXPLODE, am, null);
                if (ts.getCancelled()) {
                    e.setCancelled(true);
                }
                am.setDead();
                MythicBukkit.inst().getMobManager().unregisterActiveMob(am);
            }
        }
    }

    private LivingEntity getKiller(EntityDeathEvent event) {
        EntityDamageEvent entityDamageEvent = event.getEntity().getLastDamageCause();
        if (entityDamageEvent != null && !entityDamageEvent.isCancelled() && entityDamageEvent instanceof EntityDamageByEntityEvent) {
            Entity damager = ((EntityDamageByEntityEvent)entityDamageEvent).getDamager();
            if (damager instanceof Projectile) {
                if (((Projectile)damager).getShooter() instanceof LivingEntity) {
                    LivingEntity shooter = (LivingEntity)((Projectile)damager).getShooter();
                    if (shooter != null && shooter instanceof LivingEntity) {
                        return shooter;
                    }
                } else {
                    return event.getEntity().getKiller();
                }
            }
            if (damager instanceof LivingEntity) {
                return (LivingEntity)damager;
            }
        }
        return event.getEntity().getKiller();
    }
}

