/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.mobs;

import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.adventure.text.Component;
import io.lumine.mythic.bukkit.utils.adventure.text.TextComponent;
import io.lumine.mythic.bukkit.utils.adventure.text.event.ClickEvent;
import io.lumine.mythic.bukkit.utils.chat.ColorString;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class ListActiveCommand
extends Command<MythicBukkit> {
    public ListActiveCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        double radius;
        MythicMob filter = null;
        double d = radius = sender instanceof Player ? Double.MAX_VALUE : -1.0;
        if (args.length > 0 && !args[0].equals("*")) {
            if (args[0].matches("[0-9]*")) {
                radius = sender instanceof Player ? Double.valueOf(args[0]) : -1.0;
            } else {
                filter = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMob(args[0]).orElseGet(() -> null);
            }
        }
        if (args.length > 1) {
            radius = sender instanceof Player ? Double.valueOf(args[1]) : -1.0;
        }
        HashMap found = new HashMap();
        for (ActiveMob am : MythicBukkit.inst().getMobManager().getActiveMobs()) {
            try {
                double distanceSq;
                if (filter != null && !am.getType().getInternalName().equals(filter.getInternalName()) || radius > 0.0 && (distanceSq = am.getEntity().getBukkitEntity().getLocation().distanceSquared(((Player)sender).getLocation())) > Math.pow(radius, 2.0)) continue;
                if (!found.containsKey(am.getType())) {
                    found.put(am.getType(), new ArrayList());
                }
                ((List)found.get(am.getType())).add(am);
            }
            catch (Error | Exception ex) {
                sender.sendMessage(Text.colorize("&cFailed to get information on " + am.getMobType() + "." + am.getUniqueId()));
                if (am.getEntity() == null) {
                    sender.sendMessage(Text.colorize("&7- &eEntity is null"));
                }
                if (am.getType() != null) continue;
                sender.sendMessage(Text.colorize("&7- &eType is null"));
            }
        }
        if (filter != null) {
            List filterFound = (List)found.get(filter);
            CommandHelper.sendSuccess(sender, "ActiveMobs of Type &f" + filter.getInternalName() + " &7(" + (filterFound != null ? filterFound.size() : 0) + " total&7)");
        } else {
            int size = found.values().stream().mapToInt(List::size).sum();
            CommandHelper.sendSuccess(sender, "ActiveMobs Found &7(" + size + " total&7)");
        }
        for (Map.Entry entry : found.entrySet()) {
            sender.sendMessage(ColorString.get("&7- &f" + ((MythicMob)entry.getKey()).getInternalName() + " &7- &a" + ((List)entry.getValue()).size()));
            if (radius > 0.0) {
                Collections.sort((List)entry.getValue(), (am1, am2) -> {
                    double d1 = am1.getEntity().getBukkitEntity().getLocation().distanceSquared(((Player)sender).getLocation());
                    double d2 = am2.getEntity().getBukkitEntity().getLocation().distanceSquared(((Player)sender).getLocation());
                    return (int)(d1 - d2);
                });
            }
            for (ActiveMob am : (List)entry.getValue()) {
                String x = String.valueOf(Numbers.round(am.getLocation().getX(), 2));
                String y = String.valueOf(Numbers.round(am.getLocation().getY(), 2));
                String z = String.valueOf(Numbers.round(am.getLocation().getZ(), 2));
                String j = String.valueOf(Numbers.round(am.getLocation().getX(), 0));
                String k = String.valueOf(Numbers.round(am.getLocation().getY(), 0));
                String i = String.valueOf(Numbers.round(am.getLocation().getZ(), 0));
                double d2 = 0.0;
                if (sender instanceof Player) {
                    d2 = Numbers.round(am.getEntity().getBukkitEntity().getLocation().distance(((Player)sender).getLocation()), 2);
                }
                Component message = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(Text.parse("&6+-- &f(" + j + "," + k + "," + i + ") &7- &f" + d2 + " away "))).append(Text.parse("&7[&aTP&7]").clickEvent(ClickEvent.runCommand("/minecraft:tp " + x + " " + y + " " + z)))).append(Component.space())).append(Text.parse("&7[&dTPHere&7]").clickEvent(ClickEvent.runCommand("/minecraft:execute as " + am.getUniqueId() + " run tp " + sender.getName())))).append(Component.space())).append(Text.parse("&7[&cD&7]").clickEvent(ClickEvent.runCommand("/mythicmobs:mythicmobs u activeremove " + am.getUniqueId())))).append(Component.space())).append(Text.parse("&7[&cK&7]").clickEvent(ClickEvent.runCommand("/minecraft:execute as " + am.getUniqueId() + " run kill @s")))).append(Component.space())).append(Text.parse("&7[&bInfo&7]").clickEvent(ClickEvent.runCommand("/mythicmobs:mythicmobs u activeinfo " + am.getUniqueId())));
                Text.sendMessage(sender, message);
            }
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], ((MythicBukkit)this.getPlugin()).getMobManager().getMobNames(), new ArrayList());
        }
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.mobs.listactive";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "listactive";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"la"};
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedHashMap result = new LinkedHashMap();
        Stream st = map.entrySet().stream();
        st.sorted(Comparator.comparing(e -> (Comparable)e.getValue())).forEachOrdered(e -> result.put(e.getKey(), (Comparable)e.getValue()));
        return result;
    }
}

