/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.skills;

import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.chat.ColorString;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.core.skills.MetaSkill;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;

public class InfoCommand
extends Command<MythicBukkit> {
    public InfoCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length == 0) {
            CommandHelper.sendError(sender, "Usage /mm s[kills] i[nfo] <internal-name>");
            return true;
        }
        if (((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(args[0]).isPresent()) {
            MetaSkill mm4 = (MetaSkill)((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(args[0]).get();
            sender.sendMessage(ColorString.get("&e&lInformation for &a" + mm4.getInternalName() + "&7:"));
            sender.sendMessage(ColorString.get("&6Skill ID: &7" + mm4.hashCode()));
            sender.sendMessage(ColorString.get("&6Located in File: &7" + mm4.getFile()));
        } else {
            CommandHelper.sendError(sender, "No Mythic Skill loaded with the name " + args[0]);
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], (Iterable)((MythicBukkit)this.getPlugin()).getSkillManager().getSkills().stream().map(Skill::getInternalName).collect(Collectors.toList()), new ArrayList());
        }
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.skills.info";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "info";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"i"};
    }
}

