/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.utility;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.mobs.MobSpawnCategory;
import io.lumine.mythic.api.spawning.MythicSpawnState;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.caffeine.cache.Cache;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.spawning.random.RandomSpawnPoint;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;

public class GetSpawnStateCommand
extends Command<MythicBukkit> {
    public GetSpawnStateCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        Player player = (Player)sender;
        AbstractPlayer aplayer = BukkitAdapter.adapt(player);
        AbstractLocation location = BukkitAdapter.adapt(player.getLocation());
        CommandHelper.sendHeader(sender);
        int amount = 0;
        int alive = 0;
        int dead = 0;
        int valid = 0;
        int invalid = 0;
        int n = 0;
        Player bukkitPlayer = (Player)sender;
        World bukkitWorld = bukkitPlayer.getWorld();
        for (ActiveMob activeMob : ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMobs()) {
            if (!activeMob.getLocation().getWorld().equals(aplayer.getWorld())) continue;
            ++amount;
            if (activeMob.getEntity() == null) {
                ++n;
                continue;
            }
            if (activeMob.getEntity().isDead()) {
                ++dead;
            } else {
                ++alive;
            }
            if (activeMob.getEntity().isValid()) {
                ++valid;
                continue;
            }
            ++invalid;
        }
        ConcurrentMap categoryInfo = Maps.newConcurrentMap();
        for (Entity entity : bukkitWorld.getEntities()) {
            SpawnCategory category = entity.getSpawnCategory();
            if (!categoryInfo.containsKey(category)) {
                categoryInfo.put(category, new MobStats(category));
            }
            ((MobStats)categoryInfo.get(category)).add(entity);
        }
        CommandHelper.send(sender, "<gold>Total Active Mobs<gray>: <white>" + amount);
        CommandHelper.send(sender, "<yellow>Alive<gray>: <white>" + alive + " <gray>(Valid: " + valid + "<gray>)");
        if (dead > 0) {
            CommandHelper.send(sender, "<yellow>Dead<gray>: <white>" + dead);
        }
        if (invalid > 0) {
            CommandHelper.send(sender, "<yellow>Invalid<gray>: <white>" + invalid);
        }
        if (n > 0) {
            CommandHelper.send(sender, "<yellow>Null<gray>: <white>" + n);
        }
        MythicSpawnState mythicSpawnState = ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getSpawningHandler().getSpawnState(location.getWorld());
        CommandHelper.send(sender, "<red> ");
        CommandHelper.send(sender, "<gold>SpawnState Information<gray>: ");
        CommandHelper.send(sender, "<yellow>Spawnable Chunks <gray>>> <white>" + mythicSpawnState.getSpawnableChunkCount());
        CommandHelper.send(sender, "<yellow>Max Mobs Count <gray>>> <white>" + mythicSpawnState.getMaxMobCount());
        CommandHelper.send(sender, "<red> ");
        CommandHelper.send(sender, "<gold>Configuration<gray>: <white>");
        CommandHelper.send(sender, "<yellow>Point Generation Enabled<gray>: <white>" + ConfigExecutor.generateRSPoints());
        CommandHelper.send(sender, "<yellow>Point Generation Interval<gray>: <white>" + ((MythicBukkit)this.getPlugin()).getConfiguration().getClockIntervalRandomSpawning());
        CommandHelper.send(sender, "<yellow>Number of Spawners<gray>: <white>" + ((MythicBukkit)this.getPlugin()).getRandomSpawningManager().getNumberOfSpawners() + " <gray>(a=" + ((MythicBukkit)this.getPlugin()).getRandomSpawningManager().getRandomSpawnersAdd().size() + ",r=" + ((MythicBukkit)this.getPlugin()).getRandomSpawningManager().listRandomSpawningR.size() + ",d=" + ((MythicBukkit)this.getPlugin()).getRandomSpawningManager().listRandomSpawningD.size() + "<gray>)");
        CommandHelper.send(sender, "<yellow>GameRule MobSpawning: " + player.getWorld().getGameRuleValue(GameRule.DO_MOB_SPAWNING));
        int nx = location.getBlockX();
        int nz = location.getBlockZ();
        int maxHeight = player.getLocation().getChunk().getChunkSnapshot(true, false, false).getHighestBlockYAt(Math.abs(nx % 16), Math.abs(nz % 16)) + 1;
        int minHeight = player.getLocation().getWorld().getMinHeight();
        CommandHelper.send(sender, "<yellow>Spawn Y Range <gray>>> <white>" + minHeight + " <gray>to <white>" + maxHeight);
        CommandHelper.send(sender, "Bukkit Monster Spawn Time " + Bukkit.getTicksPerSpawns((SpawnCategory)SpawnCategory.MONSTER));
        CommandHelper.send(sender, "Bukkit Monster Spawn Limit " + Bukkit.getSpawnLimit((SpawnCategory)SpawnCategory.MONSTER));
        Location loc = player.getLocation();
        World world = loc.getWorld();
        CommandHelper.send(sender, "World Monster Spawn Time " + world.getTicksPerSpawns(SpawnCategory.MONSTER));
        CommandHelper.send(sender, "World Monster Spawn Limit " + world.getSpawnLimit(SpawnCategory.MONSTER));
        int limit = world.getSpawnLimit(SpawnCategory.MONSTER);
        int chunks = world.getLoadedChunks().length;
        limit = limit * chunks / 289;
        CommandHelper.send(sender, "Real Monster Spawn Limit " + limit);
        CommandHelper.send(sender, "<red> ");
        CommandHelper.send(sender, "<gold>Generated Points<gray>: ");
        for (Map.Entry<UUID, Cache<RandomSpawnPoint, Boolean>> entry : ((MythicBukkit)this.getPlugin()).getRandomSpawningManager().generatedSpawnPoints.entrySet()) {
            UUID rsWorld = entry.getKey();
            Cache<RandomSpawnPoint, Boolean> cache = entry.getValue();
            CommandHelper.send(sender, "<gold>-- <yellow>" + rsWorld.toString() + "<gray>: <white>" + cache.estimatedSize());
        }
        CommandHelper.send(sender, "<red> ");
        CommandHelper.send(sender, "<gold>Bukkit Tracked Entities<gray>: ");
        for (MobStats mobStats : categoryInfo.values()) {
            CommandHelper.send(sender, "<gray>-> <yellow>" + mobStats.getCategory().toString() + " <gray>- <white>" + mobStats.getCount() + " <gray>/ <white>Mythic: " + mobStats.getMythicCount() + " <gray>/ <white>Persistent: " + mobStats.getPersistentCount());
        }
        CommandHelper.send(sender, "<red> ");
        CommandHelper.send(sender, "<gold>NMS Tracked Entities<gray>:");
        for (Map.Entry<Object, Object> entry : mythicSpawnState.getCurrentMobCounts().entrySet()) {
            try {
                CommandHelper.send(sender, "<gold>-- <yellow>" + ((MobSpawnCategory)entry.getKey()).getName() + "<gray>: <white>" + entry.getValue());
            }
            catch (Error | Exception ex) {
                ex.printStackTrace();
            }
        }
        CommandHelper.sendFooter(sender);
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.test.spawncheck";
    }

    @Override
    public boolean isConsoleFriendly() {
        return false;
    }

    @Override
    public String getName() {
        return "getspawnstate";
    }

    private class MobStats {
        private final SpawnCategory category;
        private int count = 0;
        private int mythicCount = 0;
        private int persistentCount = 0;

        public void add(Entity entity) {
            LivingEntity le;
            ++this.count;
            if (((MythicBukkit)GetSpawnStateCommand.this.getPlugin()).getMobManager().isMythicMob(entity)) {
                ++this.mythicCount;
            }
            if (entity instanceof LivingEntity && !(le = (LivingEntity)entity).getRemoveWhenFarAway()) {
                ++this.persistentCount;
            }
        }

        public MobStats(SpawnCategory category) {
            this.category = category;
        }

        public SpawnCategory getCategory() {
            return this.category;
        }

        public int getCount() {
            return this.count;
        }

        public int getMythicCount() {
            return this.mythicCount;
        }

        public int getPersistentCount() {
            return this.persistentCount;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public void setMythicCount(int mythicCount) {
            this.mythicCount = mythicCount;
        }

        public void setPersistentCount(int persistentCount) {
            this.persistentCount = persistentCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MobStats)) {
                return false;
            }
            MobStats other = (MobStats)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCount() != other.getCount()) {
                return false;
            }
            if (this.getMythicCount() != other.getMythicCount()) {
                return false;
            }
            if (this.getPersistentCount() != other.getPersistentCount()) {
                return false;
            }
            SpawnCategory this$category = this.getCategory();
            SpawnCategory other$category = other.getCategory();
            return !(this$category == null ? other$category != null : !this$category.equals(other$category));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MobStats;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCount();
            result = result * 59 + this.getMythicCount();
            result = result * 59 + this.getPersistentCount();
            SpawnCategory $category = this.getCategory();
            result = result * 59 + ($category == null ? 43 : $category.hashCode());
            return result;
        }

        public String toString() {
            return "GetSpawnStateCommand.MobStats(category=" + this.getCategory() + ", count=" + this.getCount() + ", mythicCount=" + this.getMythicCount() + ", persistentCount=" + this.getPersistentCount() + ")";
        }
    }
}

