/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.compatibility;

import com.codisimus.plugins.phatloots.PhatLoot;
import com.codisimus.plugins.phatloots.PhatLoots;
import com.codisimus.plugins.phatloots.PhatLootsAPI;
import com.codisimus.plugins.phatloots.loot.LootBundle;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class PhatLootsSupport {
    PhatLoots phatloots = (PhatLoots)Bukkit.getPluginManager().getPlugin("PhatLoots");
    public boolean enabled = this.phatloots != null;
    private LootBundle lastBundle = null;

    public boolean generateBundle(AbstractEntity trigger, String phatLootTable) {
        LootBundle lootBundle;
        if (!this.enabled) {
            return false;
        }
        PhatLoot phatloot = PhatLootsAPI.getPhatLoot((String)phatLootTable);
        if (trigger == null || !trigger.isPlayer()) {
            lootBundle = phatloot.rollForLoot();
        } else {
            AbstractPlayer player = trigger.asPlayer();
            double lootingBonusPerLvl = PhatLoot.lootingBonusPerLvl;
            int lootLevel = player.getEnchantmentLevelHeld(Enchantment.LOOT_BONUS_MOBS.getName());
            double lootingBonus = lootingBonusPerLvl * (double)lootLevel;
            lootBundle = phatloot.rollForLoot(lootingBonus);
        }
        if (lootBundle != null) {
            this.lastBundle = lootBundle;
            return true;
        }
        return false;
    }

    public List<ItemStack> getLootBundleItems() {
        if (!this.enabled) {
            return null;
        }
        return this.lastBundle.getItemList();
    }

    public int getLootBundleXP() {
        if (!this.enabled) {
            return 0;
        }
        return this.lastBundle.getExp();
    }

    public double getLootBundleMoney() {
        if (!this.enabled) {
            return 0.0;
        }
        return this.lastBundle.getMoney();
    }
}

