/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class BukkitBoat
extends BukkitEntityType {
    private final int height = 1;
    private final String headString = "";
    private final ItemStack head = ItemFactory.of(Material.OAK_BOAT).build();
    private String type;

    @Override
    public void instantiate(MythicConfig config) {
        this.type = config.getString("Options.BoatType", "OAK");
        this.type = config.getString("Options.Type", this.type);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return this.spawnEntity(location, EntityType.BOAT, reason, prespawnFunc);
    }

    @Override
    public Entity applyOptions(Entity e) {
        Boat entity = (Boat)e;
        entity.setBoatType(Boat.Type.valueOf((String)this.type.toUpperCase()));
        return entity;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Boat;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public String getHeadString() {
        return this.headString;
    }

    @Override
    public ItemStack getHead() {
        return this.head;
    }
}

