/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.properties.AgeableProperty;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;

public class BukkitFrog
extends BukkitEntityType {
    private static final int height = 1;
    private AgeableProperty ageableProperty;
    private Frog.Variant variant;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        try {
            this.variant = Frog.Variant.valueOf((String)mc.getString(new String[]{"Options.Type", "Options.Variant"}, "WARM", new String[0]));
        }
        catch (Error | Exception ex) {
            MythicLogger.errorEntityConfig(this, mc, "Invalid frog type specified");
            this.variant = Frog.Variant.WARM;
        }
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return this.spawnEntity(location, EntityType.FROG, reason, prespawnFunc);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Frog e = (Frog)entity;
        e.setVariant(this.variant);
        this.ageableProperty.applyProperties(entity);
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Frog;
    }

    @Override
    public int getHeight() {
        return 1;
    }
}

