/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class BukkitItem
extends BukkitEntityType {
    private final int height = 1;
    private final String headString = "";
    private ItemStack head;
    private Material type = Material.STONE;
    private int amount = 1;
    private boolean canPickup = true;

    @Override
    public void instantiate(MythicConfig mc) {
        String mat = mc.getString("Options.Item", "STONE");
        try {
            this.type = Material.getMaterial((String)mat.toUpperCase());
        }
        catch (Exception ex) {
            MythicLogger.errorGenericConfig("Invalid item entity material specified");
        }
        this.head = ItemFactory.of(this.type).build();
        this.amount = mc.getInteger("Options.Amount", 1);
        this.canPickup = mc.getBoolean("Options.CanPickup", true);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return location.getWorld().dropItem(location, ItemFactory.of(this.type).amount(this.amount).build());
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Item item = (Item)entity;
        item.setCanMobPickup(this.canPickup);
        item.setCanPlayerPickup(this.canPickup);
        return item;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Item;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    @Override
    public String getHeadString() {
        return this.headString;
    }

    @Override
    public ItemStack getHead() {
        return this.head;
    }
}

