/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.properties.AgeableProperty;
import io.lumine.mythic.bukkit.entities.properties.TameableEntityType;
import io.lumine.mythic.bukkit.entities.properties.TameableProperty;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Parrot;

public class BukkitParrot
extends BukkitEntityType
implements TameableEntityType {
    protected static final int height = 1;
    private AgeableProperty ageableProperty;
    private TameableProperty tameableProperty;
    private Parrot.Variant variant;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.tameableProperty = new TameableProperty(mc, (Set<Material>)Sets.immutableEnumSet((Enum)Material.BEETROOT_SEEDS, (Enum[])new Material[]{Material.MELON_SEEDS, Material.PUMPKIN_SEEDS, Material.WHEAT_SEEDS}));
        String strcolor = mc.getString("Options.Color", null);
        if ((strcolor = mc.getString("Options.Variant", strcolor)) != null) {
            try {
                this.variant = Parrot.Variant.valueOf((String)strcolor);
            }
            catch (Exception ex) {
                MythicLogger.errorGenericConfig("Invalid parrot color/variant specified");
            }
        }
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        Entity e = this.spawnEntity(location, EntityType.PARROT, reason, prespawnFunc);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Parrot e = (Parrot)entity;
        this.ageableProperty.applyProperties(entity);
        if (this.variant != null) {
            e.setVariant(this.variant);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Parrot;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    public Parrot.Variant getVariant() {
        return this.variant;
    }

    @Override
    public TameableProperty getTameableProperty() {
        return this.tameableProperty;
    }
}

