/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities.properties.display;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.bukkit.entities.properties.display.DisplayProperty;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.utils.adventure.PaperHelper;
import org.bukkit.Color;
import org.bukkit.entity.Entity;
import org.bukkit.entity.TextDisplay;

public class TextDisplayProperty
extends DisplayProperty {
    private String text;
    private byte opacity;
    private boolean defaultBackground;
    private boolean shadowed;
    private boolean seeThrough;
    private int lineWidth;
    private TextDisplay.TextAlignment alignment;
    private Color backgroundColor;

    public TextDisplayProperty(MythicConfig config) {
        super(config);
        this.text = config.getString("DisplayOptions.Text", "Give This Poor Dude A Text To Display");
        this.opacity = (byte)config.getInt("DisplayOptions.Opacity", 255);
        this.defaultBackground = config.getBoolean("DisplayOptions.DefaultBackground", false);
        this.alignment = config.getEnum("DisplayOptions.Alignment", TextDisplay.TextAlignment.class, TextDisplay.TextAlignment.CENTER);
        this.lineWidth = config.getInt("DisplayOptions.LineWidth", 200);
        this.shadowed = config.getBoolean("DisplayOptions.Shadowed", false);
        this.seeThrough = config.getBoolean("DisplayOptions.SeeThrough", false);
        String colorStr = config.getString("DisplayOptions.BackgroundColor", "1073741824");
        if (colorStr.contains(",")) {
            try {
                String[] splitStr = colorStr.split(",");
                int a = Integer.parseInt(splitStr[0]);
                int r = Integer.parseInt(splitStr[1]);
                int g2 = Integer.parseInt(splitStr[2]);
                int b = Integer.parseInt(splitStr[3]);
                this.backgroundColor = Color.fromARGB((int)a, (int)r, (int)g2, (int)b);
            }
            catch (Throwable e) {
                this.backgroundColor = Color.fromARGB((int)0);
                MythicLogger.errorGenericConfig(config, "Invalid BackgroundColor (must be in 'a,r,g,b'): " + colorStr);
            }
        } else {
            try {
                int a = Integer.parseInt(colorStr);
                this.backgroundColor = Color.fromARGB((int)a);
            }
            catch (NumberFormatException e) {
                this.backgroundColor = Color.fromARGB((int)0);
                MythicLogger.errorGenericConfig(config, "Invalid BackgroundColor (must be an integer): " + colorStr);
            }
        }
    }

    @Override
    public Entity applyProperties(Entity entity) {
        if ((entity = super.applyProperties(entity)) instanceof TextDisplay) {
            TextDisplay textDisplay = (TextDisplay)entity;
            if (ServerVersion.isPaper()) {
                textDisplay.text(PaperHelper.parse(this.text));
            } else {
                textDisplay.setText(this.text);
            }
            textDisplay.setTextOpacity(this.opacity);
            textDisplay.setDefaultBackground(this.defaultBackground);
            textDisplay.setAlignment(this.alignment);
            textDisplay.setLineWidth(this.lineWidth);
            textDisplay.setShadowed(this.shadowed);
            textDisplay.setSeeThrough(this.seeThrough);
            textDisplay.setBackgroundColor(this.backgroundColor);
        }
        return entity;
    }
}

