/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.events;

import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.skills.stats.StatType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class MythicStatChangeEvent
extends Event {
    private final SkillCaster caster;
    private final StatType stat;
    private final double oldValue;
    private final double newValue;
    private static final HandlerList handlers = new HandlerList();

    public MythicStatChangeEvent(SkillCaster caster, StatType stat, double oldValue, double newValue) {
        super(!Bukkit.isPrimaryThread());
        this.caster = caster;
        this.stat = stat;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public Entity getEntity() {
        return BukkitAdapter.adapt(this.caster.getEntity());
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public SkillCaster getCaster() {
        return this.caster;
    }

    public StatType getStat() {
        return this.stat;
    }

    public double getOldValue() {
        return this.oldValue;
    }

    public double getNewValue() {
        return this.newValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MythicStatChangeEvent)) {
            return false;
        }
        MythicStatChangeEvent other = (MythicStatChangeEvent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (Double.compare(this.getOldValue(), other.getOldValue()) != 0) {
            return false;
        }
        if (Double.compare(this.getNewValue(), other.getNewValue()) != 0) {
            return false;
        }
        SkillCaster this$caster = this.getCaster();
        SkillCaster other$caster = other.getCaster();
        if (this$caster == null ? other$caster != null : !this$caster.equals(other$caster)) {
            return false;
        }
        StatType this$stat = this.getStat();
        StatType other$stat = other.getStat();
        return !(this$stat == null ? other$stat != null : !this$stat.equals(other$stat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MythicStatChangeEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $oldValue = Double.doubleToLongBits(this.getOldValue());
        result = result * 59 + (int)($oldValue >>> 32 ^ $oldValue);
        long $newValue = Double.doubleToLongBits(this.getNewValue());
        result = result * 59 + (int)($newValue >>> 32 ^ $newValue);
        SkillCaster $caster = this.getCaster();
        result = result * 59 + ($caster == null ? 43 : $caster.hashCode());
        StatType $stat = this.getStat();
        result = result * 59 + ($stat == null ? 43 : $stat.hashCode());
        return result;
    }

    public String toString() {
        return "MythicStatChangeEvent(caster=" + this.getCaster() + ", stat=" + this.getStat() + ", oldValue=" + this.getOldValue() + ", newValue=" + this.getNewValue() + ")";
    }
}

