/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.collections;

import com.google.common.collect.Lists;
import io.lumine.mythic.bukkit.utils.collections.AWeightedItem;
import io.lumine.mythic.bukkit.utils.collections.ISelector;
import io.lumine.mythic.bukkit.utils.collections.WeightedCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class WeightedSelector<T extends AWeightedItem>
implements ISelector<T> {
    private Random random = new Random();

    public WeightedSelector() {
        this(new Random());
    }

    public WeightedSelector(long seed) {
        this(new Random(seed));
    }

    public WeightedSelector(Random random) {
        this.random = random;
    }

    @Override
    public T get(WeightedCollection<T> items) {
        double weight = this.random.nextDouble() * items.getWeight();
        List<T> itemsView = items.getView();
        if (itemsView.isEmpty()) {
            return null;
        }
        for (AWeightedItem item : itemsView) {
            if (weight <= item.getWeight()) {
                return (T)item;
            }
            weight -= item.getWeight();
        }
        return (T)((AWeightedItem)itemsView.get(0));
    }

    @Override
    public Collection<T> get(WeightedCollection<T> items, int count) {
        LinkedList itemList = Lists.newLinkedList();
        for (int i = 0; i < count; ++i) {
            T item = this.get(items);
            if (item == null) continue;
            itemList.add(item);
        }
        return itemList;
    }

    @Override
    public Collection<T> getNonRepeating(WeightedCollection<T> items, int count) {
        LinkedList itemList = Lists.newLinkedList();
        List<T> itemsCopy = items.getCopy();
        double maxWeight = items.getWeight();
        block0: for (int i = 0; i < count && !itemsCopy.isEmpty(); ++i) {
            double weight = this.random.nextDouble() * maxWeight;
            Iterator<T> it = itemsCopy.iterator();
            while (it.hasNext()) {
                AWeightedItem next = (AWeightedItem)it.next();
                if (weight <= next.getWeight()) {
                    itemList.add(next);
                    maxWeight -= next.getWeight();
                    it.remove();
                    continue block0;
                }
                weight -= next.getWeight();
            }
        }
        return itemsCopy;
    }
}

