/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.config.properties.types;

import io.lumine.mythic.bukkit.utils.config.ConfigurationSection;
import io.lumine.mythic.bukkit.utils.config.file.FileConfiguration;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyType;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;

public class EnumProp<T extends Enum<T>>
extends PropertyType<T> {
    private final Class<T> clazz;
    private final T def;

    public EnumProp(LuminePlugin plugin, Object file, Class<T> clazz, String node) {
        super(plugin, file, node);
        this.clazz = clazz;
        this.def = null;
    }

    public EnumProp(LuminePlugin plugin, Object file, Class<T> clazz, String node, T def) {
        super(plugin, file, node);
        this.clazz = clazz;
        this.def = def;
    }

    @Override
    protected T compute(ConfigurationSection section, String node) {
        if (section == null) {
            return this.def;
        }
        try {
            T value = Enum.valueOf(this.clazz, section.getString(node));
            if (value == null) {
                return this.def;
            }
            return value;
        }
        catch (Error | Exception ex) {
            return this.def;
        }
    }

    @Override
    public void set(String holder, T value) {
        if (this.config == null) {
            return;
        }
        if (holder != null) {
            this.config.set(holder + "." + this.node, ((Enum)value).toString());
        } else {
            this.config.set(this.node, ((Enum)value).toString());
        }
        try {
            ((FileConfiguration)this.config).save(this.plugin.getPropertyFile(this.file));
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
        }
    }
}

