/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.config.properties.types;

import io.lumine.mythic.bukkit.utils.config.ConfigurationSection;
import io.lumine.mythic.bukkit.utils.config.file.FileConfiguration;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyType;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import io.lumine.mythic.bukkit.utils.serialize.Direction;
import io.lumine.mythic.bukkit.utils.serialize.Locus;
import io.lumine.mythic.bukkit.utils.serialize.Orient;

public class OrientProp
extends PropertyType<Orient> {
    private final Orient def;

    public OrientProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
        this.def = Orient.of(Locus.of(0.0, 0.0, 0.0), Direction.of(0.0f, 0.0f));
    }

    public OrientProp(LuminePlugin plugin, Object file, String node, Orient def) {
        super(plugin, file, node);
        this.def = def;
    }

    @Override
    protected Orient compute(ConfigurationSection section, String node) {
        if (section == null) {
            return this.def;
        }
        String prop = section.getString(node);
        if (prop == null) {
            return this.def;
        }
        try {
            String[] split = prop.split(",");
            double x = Double.valueOf(split[0]);
            double y = Double.valueOf(split[1]);
            double z = Double.valueOf(split[2]);
            float yaw = split.length > 3 ? Float.valueOf(split[3]).floatValue() : 0.0f;
            float pitch = split.length > 4 ? Float.valueOf(split[4]).floatValue() : 0.0f;
            return Orient.of(Locus.of(x, y, z), Direction.of(yaw, pitch));
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void set(String holder, Orient value) {
        if (this.config == null) {
            return;
        }
        String val = value.getLocus().getX() + "," + value.getLocus().getY() + "," + value.getLocus().getZ() + "," + value.getDirection().getYaw() + "," + value.getDirection().getPitch();
        if (holder != null) {
            this.config.set(holder + "." + this.node, val);
        } else {
            this.config.set(this.node, val);
        }
        try {
            ((FileConfiguration)this.config).save(this.plugin.getPropertyFile(this.file));
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
        }
    }
}

