/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.http.impl.cookie;

import io.lumine.mythic.bukkit.utils.lib.http.annotation.Immutable;
import io.lumine.mythic.bukkit.utils.lib.http.cookie.CommonCookieAttributeHandler;
import io.lumine.mythic.bukkit.utils.lib.http.cookie.Cookie;
import io.lumine.mythic.bukkit.utils.lib.http.cookie.CookieOrigin;
import io.lumine.mythic.bukkit.utils.lib.http.cookie.CookieRestrictionViolationException;
import io.lumine.mythic.bukkit.utils.lib.http.cookie.MalformedCookieException;
import io.lumine.mythic.bukkit.utils.lib.http.cookie.SetCookie;
import io.lumine.mythic.bukkit.utils.lib.http.util.Args;
import io.lumine.mythic.bukkit.utils.lib.http.util.TextUtils;

@Immutable
public class BasicPathHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setPath(!TextUtils.isBlank(value) ? value : "/");
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        if (!this.match(cookie, origin)) {
            throw new CookieRestrictionViolationException("Illegal 'path' attribute \"" + cookie.getPath() + "\". Path of origin: \"" + origin.getPath() + "\"");
        }
    }

    static boolean pathMatch(String uriPath, String cookiePath) {
        String normalizedCookiePath = cookiePath;
        if (normalizedCookiePath == null) {
            normalizedCookiePath = "/";
        }
        if (normalizedCookiePath.length() > 1 && normalizedCookiePath.endsWith("/")) {
            normalizedCookiePath = normalizedCookiePath.substring(0, normalizedCookiePath.length() - 1);
        }
        if (uriPath.startsWith(normalizedCookiePath)) {
            if (normalizedCookiePath.equals("/")) {
                return true;
            }
            if (uriPath.length() == normalizedCookiePath.length()) {
                return true;
            }
            if (uriPath.charAt(normalizedCookiePath.length()) == '/') {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return BasicPathHandler.pathMatch(origin.getPath(), cookie.getPath());
    }

    @Override
    public String getAttributeName() {
        return "path";
    }
}

