/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.http.impl.execchain;

import io.lumine.mythic.bukkit.utils.lib.http.HttpEntityEnclosingRequest;
import io.lumine.mythic.bukkit.utils.lib.http.HttpException;
import io.lumine.mythic.bukkit.utils.lib.http.HttpHost;
import io.lumine.mythic.bukkit.utils.lib.http.HttpRequest;
import io.lumine.mythic.bukkit.utils.lib.http.ProtocolException;
import io.lumine.mythic.bukkit.utils.lib.http.annotation.ThreadSafe;
import io.lumine.mythic.bukkit.utils.lib.http.auth.AuthScheme;
import io.lumine.mythic.bukkit.utils.lib.http.auth.AuthState;
import io.lumine.mythic.bukkit.utils.lib.http.client.RedirectException;
import io.lumine.mythic.bukkit.utils.lib.http.client.RedirectStrategy;
import io.lumine.mythic.bukkit.utils.lib.http.client.config.RequestConfig;
import io.lumine.mythic.bukkit.utils.lib.http.client.methods.CloseableHttpResponse;
import io.lumine.mythic.bukkit.utils.lib.http.client.methods.HttpExecutionAware;
import io.lumine.mythic.bukkit.utils.lib.http.client.methods.HttpRequestWrapper;
import io.lumine.mythic.bukkit.utils.lib.http.client.methods.HttpUriRequest;
import io.lumine.mythic.bukkit.utils.lib.http.client.protocol.HttpClientContext;
import io.lumine.mythic.bukkit.utils.lib.http.client.utils.URIUtils;
import io.lumine.mythic.bukkit.utils.lib.http.conn.routing.HttpRoute;
import io.lumine.mythic.bukkit.utils.lib.http.conn.routing.HttpRoutePlanner;
import io.lumine.mythic.bukkit.utils.lib.http.impl.execchain.ClientExecChain;
import io.lumine.mythic.bukkit.utils.lib.http.impl.execchain.RequestEntityProxy;
import io.lumine.mythic.bukkit.utils.lib.http.util.Args;
import io.lumine.mythic.bukkit.utils.lib.http.util.EntityUtils;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class RedirectExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final RedirectStrategy redirectStrategy;
    private final HttpRoutePlanner routePlanner;

    public RedirectExec(ClientExecChain requestExecutor, HttpRoutePlanner routePlanner, RedirectStrategy redirectStrategy) {
        Args.notNull(requestExecutor, "HTTP client request executor");
        Args.notNull(routePlanner, "HTTP route planner");
        Args.notNull(redirectStrategy, "HTTP redirect strategy");
        this.requestExecutor = requestExecutor;
        this.routePlanner = routePlanner;
        this.redirectStrategy = redirectStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        RequestConfig config;
        Args.notNull(route, "HTTP route");
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        List<URI> redirectLocations = context.getRedirectLocations();
        if (redirectLocations != null) {
            redirectLocations.clear();
        }
        int maxRedirects = (config = context.getRequestConfig()).getMaxRedirects() > 0 ? config.getMaxRedirects() : 50;
        HttpRoute currentRoute = route;
        HttpRequestWrapper currentRequest = request;
        int redirectCount = 0;
        while (true) {
            CloseableHttpResponse response = this.requestExecutor.execute(currentRoute, currentRequest, context, execAware);
            try {
                URI uri;
                HttpHost newTarget;
                if (!config.isRedirectsEnabled()) return response;
                if (!this.redirectStrategy.isRedirected(currentRequest.getOriginal(), response, context)) return response;
                if (redirectCount >= maxRedirects) {
                    throw new RedirectException("Maximum redirects (" + maxRedirects + ") exceeded");
                }
                ++redirectCount;
                HttpUriRequest redirect = this.redirectStrategy.getRedirect(currentRequest.getOriginal(), response, context);
                if (!redirect.headerIterator().hasNext()) {
                    HttpRequest original = request.getOriginal();
                    redirect.setHeaders(original.getAllHeaders());
                }
                if ((currentRequest = HttpRequestWrapper.wrap(redirect)) instanceof HttpEntityEnclosingRequest) {
                    RequestEntityProxy.enhance((HttpEntityEnclosingRequest)((Object)currentRequest));
                }
                if ((newTarget = URIUtils.extractHost(uri = currentRequest.getURI())) == null) {
                    throw new ProtocolException("Redirect URI does not specify a valid host name: " + uri);
                }
                if (!currentRoute.getTargetHost().equals(newTarget)) {
                    AuthScheme authScheme;
                    AuthState proxyAuthState;
                    AuthState targetAuthState = context.getTargetAuthState();
                    if (targetAuthState != null) {
                        this.log.debug("Resetting target auth state");
                        targetAuthState.reset();
                    }
                    if ((proxyAuthState = context.getProxyAuthState()) != null && (authScheme = proxyAuthState.getAuthScheme()) != null && authScheme.isConnectionBased()) {
                        this.log.debug("Resetting proxy auth state");
                        proxyAuthState.reset();
                    }
                }
                currentRoute = this.routePlanner.determineRoute(newTarget, currentRequest, context);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Redirecting to '" + uri + "' via " + currentRoute);
                }
                EntityUtils.consume(response.getEntity());
                response.close();
            }
            catch (RuntimeException ex) {
                response.close();
                throw ex;
            }
            catch (IOException ex) {
                response.close();
                throw ex;
            }
            catch (HttpException ex) {
                try {
                    EntityUtils.consume(response.getEntity());
                    throw ex;
                }
                catch (IOException ioex) {
                    this.log.debug("I/O error while releasing connection", ioex);
                    throw ex;
                }
                finally {
                    response.close();
                }
            }
        }
    }
}

