/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Name;
import io.lumine.mythic.bukkit.utils.lib.jooq.Param;
import io.lumine.mythic.bukkit.utils.lib.jooq.QueryPart;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record;
import io.lumine.mythic.bukkit.utils.lib.jooq.Table;
import io.lumine.mythic.bukkit.utils.lib.jooq.TableOptions;
import io.lumine.mythic.bukkit.utils.lib.jooq.exception.DataTypeException;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractTable;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.ArrayTableEmulation;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.FieldsImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.RecordImplN;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.util.h2.H2DataType;

final class ArrayTable
extends AbstractTable<Record>
implements QOM.UNotYetImplemented {
    private final Field<?> array;
    private final FieldsImpl<Record> field;
    private final Name alias;
    private final Name[] fieldAliases;

    ArrayTable(Field<?> array) {
        this(array, Names.N_ARRAY_TABLE);
    }

    ArrayTable(Field<?> array, Name alias) {
        this(array, alias, new Name[]{Names.N_COLUMN_VALUE});
    }

    ArrayTable(Field<?> array, Name alias, Name[] fieldAliases) {
        super(TableOptions.expression(), alias);
        Class arrayType = array.getDataType().getType().isArray() ? array.getDataType().getArrayComponentType() : Object.class;
        this.array = array;
        this.alias = alias;
        this.fieldAliases = fieldAliases;
        this.field = ArrayTable.init(arrayType, alias);
    }

    private static final FieldsImpl<Record> init(Class<?> arrayType, Name alias) {
        if (Record.class.isAssignableFrom(arrayType)) {
            try {
                return new FieldsImpl<Record>(Tools.map(((Record)arrayType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).fields(), f -> DSL.field(DSL.name(alias.last(), f.getName()), f.getDataType())));
            }
            catch (Exception e) {
                throw new DataTypeException("Bad UDT Type : " + arrayType, e);
            }
        }
        return new FieldsImpl<Record>(DSL.field(DSL.name(alias.last(), "COLUMN_VALUE"), DSL.getDataType(arrayType)));
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        return RecordImplN.class;
    }

    @Override
    public final Table<Record> as(Name as) {
        return new ArrayTable(this.array, as);
    }

    @Override
    public final Table<Record> as(Name as, Name ... fields) {
        return new ArrayTable(this.array, as, fields);
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.table(ctx.configuration()));
    }

    private final Table<Record> table(Configuration configuration) {
        switch (configuration.family()) {
            case H2: {
                return new H2ArrayTable().as(this.alias);
            }
            case HSQLDB: 
            case POSTGRES: 
            case YUGABYTEDB: {
                return new PostgresHSQLDBTable().as(this.alias, this.fieldAliases);
            }
        }
        if (this.array.getDataType().getType().isArray() && this.array instanceof Param) {
            return this.emulate();
        }
        return DSL.table("{0}", new QueryPart[]{this.array}).as(this.alias);
    }

    private final Table<Record> emulate() {
        return new ArrayTableEmulation((Object[])((Param)this.array).getValue()).as(this.alias, this.fieldAliases);
    }

    @Override
    final FieldsImpl<Record> fields0() {
        return this.field;
    }

    private abstract class DialectArrayTable
    extends AbstractTable<Record>
    implements QOM.UTransient {
        DialectArrayTable() {
            super(TableOptions.expression(), ArrayTable.this.alias);
        }

        @Override
        public final Class<? extends Record> getRecordType() {
            return RecordImplN.class;
        }

        @Override
        final FieldsImpl<Record> fields0() {
            return ArrayTable.this.fields0();
        }
    }

    private class H2ArrayTable
    extends DialectArrayTable {
        private H2ArrayTable() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            ctx.visit(Keywords.K_TABLE).sql('(').visit(ArrayTable.this.fieldAliases == null || ArrayTable.this.fieldAliases.length == 0 ? Names.N_COLUMN_VALUE : ArrayTable.this.fieldAliases[0]).sql(' ');
            if (ArrayTable.this.array.getDataType().getType() == Object[].class) {
                ctx.sql(H2DataType.VARCHAR.getTypeName());
            } else {
                ctx.sql(ArrayTable.this.array.getDataType().getTypeName());
            }
            ctx.sql(" = ").visit(ArrayTable.this.array).sql(')');
        }
    }

    private class PostgresHSQLDBTable
    extends DialectArrayTable {
        private PostgresHSQLDBTable() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            ctx.visit(Keywords.K_UNNEST).sql('(').visit(ArrayTable.this.array).sql(")");
        }
    }
}

