/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Condition;
import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Name;
import io.lumine.mythic.bukkit.utils.lib.jooq.Param;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record;
import io.lumine.mythic.bukkit.utils.lib.jooq.Select;
import io.lumine.mythic.bukkit.utils.lib.jooq.SelectFieldOrAsterisk;
import io.lumine.mythic.bukkit.utils.lib.jooq.SelectSelectStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.Table;
import io.lumine.mythic.bukkit.utils.lib.jooq.TableOptions;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractTable;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.FieldsImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.RecordImplN;

final class ArrayTableEmulation
extends AbstractTable<Record>
implements QOM.UTransient {
    private final Object[] array;
    private final FieldsImpl<Record> field;
    private final Name alias;
    private final Name fieldAlias;
    private transient Table<Record> table;

    ArrayTableEmulation(Object[] array) {
        this(array, Names.N_ARRAY_TABLE, null);
    }

    ArrayTableEmulation(Object[] array, Name alias) {
        this(array, alias, null);
    }

    ArrayTableEmulation(Object[] array, Name alias, Name fieldAlias) {
        super(TableOptions.expression(), alias);
        this.array = array;
        this.alias = alias;
        this.fieldAlias = fieldAlias == null ? Names.N_COLUMN_VALUE : fieldAlias;
        this.field = new FieldsImpl(DSL.field(DSL.name(alias.last(), this.fieldAlias.last()), DSL.getDataType(array.getClass().getComponentType())));
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        return RecordImplN.class;
    }

    @Override
    public final Table<Record> as(Name as) {
        return new ArrayTableEmulation(this.array, as);
    }

    @Override
    public final Table<Record> as(Name as, Name ... fieldAliases) {
        if (fieldAliases == null) {
            return new ArrayTableEmulation(this.array, as);
        }
        if (fieldAliases.length == 1) {
            return new ArrayTableEmulation(this.array, as, fieldAliases[0]);
        }
        throw new IllegalArgumentException("Array table simulations can only have a single field alias");
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.table(ctx.configuration()));
    }

    @Override
    final FieldsImpl<Record> fields0() {
        return this.field;
    }

    private final Table<Record> table(Configuration configuration) {
        if (this.table == null) {
            Select<Record> select = null;
            for (Object element : this.array) {
                Param val = DSL.val(element, this.field.fields[0].getDataType());
                SelectSelectStep<Record> subselect = DSL.using(configuration).select(val.as(this.fieldAlias)).select(new SelectFieldOrAsterisk[0]);
                select = select == null ? subselect : select.unionAll(subselect);
            }
            if (select == null) {
                select = DSL.using(configuration).select(DSL.one().as(this.fieldAlias)).select(new SelectFieldOrAsterisk[0]).where((Condition)DSL.falseCondition());
            }
            this.table = select.asTable(this.alias);
        }
        return this.table;
    }
}

