/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.DMLQuery;
import io.lumine.mythic.bukkit.utils.lib.jooq.Delete;
import io.lumine.mythic.bukkit.utils.lib.jooq.Insert;
import io.lumine.mythic.bukkit.utils.lib.jooq.Name;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.SelectFieldOrAsterisk;
import io.lumine.mythic.bukkit.utils.lib.jooq.Table;
import io.lumine.mythic.bukkit.utils.lib.jooq.TableOptions;
import io.lumine.mythic.bukkit.utils.lib.jooq.Update;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractRow;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractTable;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AutoAliasTable;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.CustomQueryPart;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.FieldsImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.InsertQueryImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.MergeImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SelectFieldList;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.TableAlias;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.TopLevelCte;
import java.util.Set;
import java.util.UUID;

final class DataChangeDeltaTable<R extends Record>
extends AbstractTable<R>
implements AutoAliasTable<R>,
QOM.DataChangeDeltaTable<R> {
    private final Set<SQLDialect> EMULATE_USING_CTE = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    private final QOM.ResultOption resultOption;
    private final DMLQuery<R> query;
    private final Table<R> table;
    private final Name alias;

    DataChangeDeltaTable(QOM.ResultOption resultOption, DMLQuery<R> query) {
        this(resultOption, query, DataChangeDeltaTable.table(query));
    }

    private DataChangeDeltaTable(QOM.ResultOption resultOption, DMLQuery<R> query, Table<R> table) {
        this(resultOption, query, table, table.getUnqualifiedName());
    }

    private DataChangeDeltaTable(QOM.ResultOption resultOption, DMLQuery<R> query, Table<R> table, Name alias) {
        super(TableOptions.expression(), alias);
        this.resultOption = resultOption;
        this.query = query;
        this.table = table;
        this.alias = alias;
    }

    private static final <R extends Record> Table<R> table(DMLQuery<R> query) {
        if (query instanceof Insert || query instanceof Update || query instanceof Delete) {
            return Tools.abstractDMLQuery(query).table();
        }
        if (query instanceof MergeImpl) {
            return ((MergeImpl)query).table();
        }
        throw new IllegalStateException("Unsupported query type: " + query);
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.EMULATE_USING_CTE.contains((Object)ctx.dialect())) {
            this.acceptCte(ctx);
        } else {
            this.acceptNative(ctx);
        }
    }

    private final void acceptCte(Context<?> ctx) {
        TopLevelCte cte = (TopLevelCte)ctx.data((Object)Tools.DataKey.DATA_TOP_LEVEL_CTE);
        cte.add(DSL.name(this.alias).as(DSL.resultQuery("{0}", CustomQueryPart.of(c2 -> c2.visit(this.query).formatSeparator().visit(Keywords.K_RETURNING).sql(' ').visit(new SelectFieldList((SelectFieldOrAsterisk[])this.table.fields()))))));
        ctx.visit(DSL.table(this.alias));
    }

    private final void acceptNative(Context<?> ctx) {
        switch (this.resultOption) {
            case FINAL: {
                ctx.visit(Keywords.K_FINAL);
                break;
            }
            case OLD: {
                ctx.visit(Keywords.K_OLD);
                break;
            }
            case NEW: {
                ctx.visit(Keywords.K_NEW);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported result option: " + this.resultOption);
            }
        }
        ctx.sql(' ').visit(Keywords.K_TABLE).sqlIndentStart(" (");
        if (this.requiresWorkaroundFor12925(ctx)) {
            ctx.sql("/* [#12925] ").sql(UUID.randomUUID().toString()).sql(" */ ");
        }
        ctx.visit(this.query).sqlIndentEnd(')');
    }

    private final boolean requiresWorkaroundFor12925(Context<?> ctx) {
        if (ctx.family() == SQLDialect.H2) {
            if (this.query instanceof MergeImpl) {
                return true;
            }
            InsertQueryImpl<?> i = Tools.insertQueryImpl(this.query);
            return i != null && (i.onDuplicateKeyIgnore || i.onDuplicateKeyUpdate);
        }
        return false;
    }

    @Override
    public Table<R> as(Name as) {
        return new TableAlias<R>(new DataChangeDeltaTable<R>(this.resultOption, this.query, this.table, as), as);
    }

    @Override
    public Table<R> as(Name as, Name ... fieldAliases) {
        return new TableAlias<R>(new DataChangeDeltaTable<R>(this.resultOption, this.query, this.table, as), as, fieldAliases);
    }

    @Override
    public final Table<R> autoAlias(Context<?> ctx) {
        return this.as(this.alias);
    }

    @Override
    public final Class<? extends R> getRecordType() {
        return this.table.getRecordType();
    }

    @Override
    final FieldsImpl<R> fields0() {
        return ((AbstractRow)this.table.as((Name)this.alias).fieldsRow()).fields;
    }

    @Override
    public final QOM.ResultOption $resultOption() {
        return this.resultOption;
    }

    @Override
    public final DMLQuery<R> $query() {
        return this.query;
    }
}

