/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Catalog;
import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.DropDatabaseFinalStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function2;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractDDLQuery;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DDLStatementType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.util.Set;

final class DropDatabaseImpl
extends AbstractDDLQuery
implements QOM.DropDatabase,
DropDatabaseFinalStep {
    final Catalog database;
    final boolean ifExists;
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD);

    DropDatabaseImpl(Configuration configuration, Catalog database, boolean ifExists) {
        super(configuration);
        this.database = database;
        this.ifExists = ifExists;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.DROP_DATABASE, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private void accept0(Context<?> ctx) {
        ctx.visit(Keywords.K_DROP).sql(' ').visit(Keywords.K_DATABASE);
        if (this.ifExists && this.supportsIfExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
        }
        ctx.sql(' ').visit(this.database);
    }

    @Override
    public final Catalog $database() {
        return this.database;
    }

    @Override
    public final boolean $ifExists() {
        return this.ifExists;
    }

    @Override
    public final QOM.DropDatabase $database(Catalog newValue) {
        return this.constructor().apply(newValue, (Boolean)this.$ifExists());
    }

    @Override
    public final QOM.DropDatabase $ifExists(boolean newValue) {
        return this.constructor().apply(this.$database(), (Boolean)newValue);
    }

    public final Function2<? super Catalog, ? super Boolean, ? extends QOM.DropDatabase> constructor() {
        return (a1, a2) -> new DropDatabaseImpl(this.configuration(), (Catalog)a1, (boolean)a2);
    }
}

