/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.exception.MappingException;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractConverter;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.JooqLogger;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.reflect.Reflect;
import jakarta.persistence.AttributeConverter;
import java.lang.reflect.Method;

public final class JPAConverter<T, U>
extends AbstractConverter<T, U> {
    private static final JooqLogger log = JooqLogger.getLogger(JPAConverter.class);
    private final AttributeConverter<U, T> delegate;

    public JPAConverter(Class<? extends AttributeConverter<U, T>> klass) {
        super(JPAConverter.fromType(klass), JPAConverter.toType(klass));
        try {
            this.delegate = (AttributeConverter)Reflect.on(klass).create().get();
        }
        catch (Exception e) {
            throw new MappingException("Cannot instanciate AttributeConverter", e);
        }
    }

    private static final <T> Class<T> fromType(Class<? extends AttributeConverter<?, T>> klass) {
        Method candidate = null;
        for (Method method : klass.getDeclaredMethods()) {
            if (!"convertToDatabaseColumn".equals(method.getName())) continue;
            if (method.getReturnType() == Object.class) {
                candidate = method;
                continue;
            }
            return method.getReturnType();
        }
        if (candidate != null) {
            log.warn("Couldn't find bridge method to detect generic type bound for " + klass.getName() + "::convertToDatabaseColumn");
            return candidate.getReturnType();
        }
        throw new IllegalArgumentException();
    }

    private static final <U> Class<U> toType(Class<? extends AttributeConverter<U, ?>> klass) {
        Method candidate = null;
        for (Method method : klass.getDeclaredMethods()) {
            if (!"convertToEntityAttribute".equals(method.getName())) continue;
            if (method.getReturnType() == Object.class) {
                candidate = method;
                continue;
            }
            return method.getReturnType();
        }
        if (candidate != null) {
            log.warn("Couldn't find bridge method to detect generic type bound for " + klass.getName() + "::convertToEntityAttribute");
            return candidate.getReturnType();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public final U from(T t2) {
        return (U)this.delegate.convertToEntityAttribute(t2);
    }

    @Override
    public final T to(U u) {
        return (T)this.delegate.convertToDatabaseColumn(u);
    }
}

