/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.AggregateFunction;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.DataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function1;
import io.lumine.mythic.bukkit.utils.lib.jooq.JSON;
import io.lumine.mythic.bukkit.utils.lib.jooq.JSONEntry;
import io.lumine.mythic.bukkit.utils.lib.jooq.JSONObjectAggNullStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.JSONObjectNullStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.QueryPart;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractAggregateFunction;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.CustomField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.JSONNull;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.JSONReturning;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QueryPartListView;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.RegexpReplace;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;

final class JSONObjectAgg<J>
extends AbstractAggregateFunction<J>
implements JSONObjectAggNullStep<J>,
QOM.JSONObjectAgg<J> {
    private final JSONEntry<?> entry;
    private QOM.JSONOnNull onNull;
    private DataType<?> returning;

    JSONObjectAgg(DataType<J> type, JSONEntry<?> entry) {
        super(false, Names.N_JSON_OBJECTAGG, type, entry.key(), entry.value());
        this.entry = entry;
    }

    @Override
    public void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                this.acceptPostgres(ctx);
                break;
            }
            case MARIADB: 
            case MYSQL: {
                if (this.onNull == QOM.JSONOnNull.ABSENT_ON_NULL || this.filter != null) {
                    this.acceptGroupConcat(ctx);
                    break;
                }
                this.acceptStandard(ctx);
                break;
            }
            case SQLITE: {
                this.acceptSQLite(ctx);
                break;
            }
            default: {
                this.acceptStandard(ctx);
            }
        }
    }

    private final void acceptPostgres(Context<?> ctx) {
        ctx.visit(this.getDataType() == SQLDataType.JSON ? Names.N_JSON_OBJECT_AGG : Names.N_JSONB_OBJECT_AGG).sql('(');
        ctx.visit(this.entry);
        ctx.sql(')');
        if (this.onNull == QOM.JSONOnNull.ABSENT_ON_NULL) {
            JSONObjectAgg.acceptFilterClause(ctx, (this.filter == null ? DSL.noCondition() : this.filter).and(this.entry.value().isNotNull()));
        } else {
            this.acceptFilterClause(ctx);
        }
        this.acceptOverClause(ctx);
    }

    private final void acceptSQLite(Context<?> ctx) {
        ctx.visit(Names.N_JSON_GROUP_OBJECT).sql('(');
        ctx.visit(this.entry);
        ctx.sql(')');
        if (this.onNull == QOM.JSONOnNull.ABSENT_ON_NULL) {
            JSONObjectAgg.acceptFilterClause(ctx, (this.filter == null ? DSL.noCondition() : this.filter).and(this.entry.value().isNotNull()));
        } else {
            this.acceptFilterClause(ctx);
        }
        this.acceptOverClause(ctx);
    }

    private final void acceptGroupConcat(Context<?> ctx) {
        CustomField<String> listagg = CustomField.of(Names.N_GROUP_CONCAT, SQLDataType.VARCHAR, c1 -> {
            Field<JSON> o1 = DSL.jsonObject(this.entry.key(), this.entry.value());
            if (this.onNull == QOM.JSONOnNull.ABSENT_ON_NULL) {
                o1 = DSL.when(this.entry.value().isNull(), DSL.inline((JSON)null)).else_(o1);
            }
            JSONObjectNullStep<JSON> o2 = o1;
            c1.visit(DSL.groupConcat(DSL.concat(CustomField.of(Names.N_FIELD, SQLDataType.VARCHAR, c2 -> this.acceptArguments2((Context<?>)c2, QueryPartListView.wrap((QueryPart[])new Field[]{DSL.regexpReplaceAll(o2.cast(SQLDataType.VARCHAR), DSL.inline("^\\{(.*)\\}$"), DSL.inline(RegexpReplace.replacement(ctx, 1)))}))))));
            this.acceptFilterClause((Context<?>)c1);
            this.acceptOverClause((Context<?>)c1);
        });
        ctx.sql('(').visit(DSL.concat(DSL.inline('{'), listagg, DSL.inline('}'))).sql(')');
    }

    private final void acceptStandard(Context<?> ctx) {
        JSONReturning jsonReturning;
        ctx.visit(Names.N_JSON_OBJECTAGG).sql('(').visit(this.entry);
        JSONNull jsonNull = new JSONNull(this.onNull);
        if (jsonNull.rendersContent(ctx)) {
            ctx.sql(' ').visit(jsonNull);
        }
        if ((jsonReturning = new JSONReturning(this.returning)).rendersContent(ctx)) {
            ctx.sql(' ').visit(jsonReturning);
        }
        ctx.sql(')');
        this.acceptFilterClause(ctx);
        this.acceptOverClause(ctx);
    }

    @Override
    public final JSONObjectAgg<J> nullOnNull() {
        this.onNull = QOM.JSONOnNull.NULL_ON_NULL;
        return this;
    }

    @Override
    public final JSONObjectAgg<J> absentOnNull() {
        this.onNull = QOM.JSONOnNull.ABSENT_ON_NULL;
        return this;
    }

    @Override
    public final JSONObjectAgg<J> returning(DataType<?> r) {
        this.returning = r;
        return this;
    }

    @Override
    public final JSONEntry<?> $arg1() {
        return this.entry;
    }

    @Override
    public final QOM.JSONOnNull $onNull() {
        return this.onNull;
    }

    @Override
    public final DataType<?> $returning() {
        return this.returning;
    }

    @Override
    public final Function1<? super JSONEntry<?>, ? extends AggregateFunction<J>> constructor() {
        return e -> {
            JSONObjectAgg r = new JSONObjectAgg(this.getDataType(), (JSONEntry<?>)e);
            r.onNull = this.onNull;
            r.returning = this.returning;
            return r;
        };
    }
}

