/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.DSLContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Fields;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record;
import io.lumine.mythic.bukkit.utils.lib.jooq.Result;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractRow;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DefaultDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.ResultImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.json.ContainerFactory;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.json.JSONParser;
import jakarta.xml.bind.DatatypeConverter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class JSONReader<R extends Record> {
    private final DSLContext ctx;
    private final AbstractRow<R> row;
    private final Class<? extends R> recordType;

    JSONReader(DSLContext ctx, AbstractRow<R> row, Class<? extends R> recordType) {
        this.ctx = ctx;
        this.row = row;
        this.recordType = recordType != null ? recordType : Record.class;
    }

    final Result<R> read(String string) {
        return this.read(new StringReader(string));
    }

    final Result<R> read(Reader reader) {
        return this.read(reader, false);
    }

    final Result<R> read(Reader reader, boolean multiset) {
        try {
            Object root = new JSONParser().parse(reader, new ContainerFactory(){

                @Override
                public Map createObjectContainer() {
                    return new LinkedHashMap();
                }

                @Override
                public List createArrayContainer() {
                    return new ArrayList();
                }
            });
            return JSONReader.read(this.ctx, this.row, this.recordType, multiset, root);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static final <R extends Record> Result<R> read(DSLContext ctx, AbstractRow<R> actualRow, Class<? extends R> recordType, boolean multiset, Object root) {
        List records;
        ArrayList header = new ArrayList();
        ResultImpl result = null;
        if (root instanceof Map) {
            Map o1 = (Map)root;
            List fields = (List)o1.get("fields");
            if (fields != null) {
                for (Object field : fields) {
                    String catalog = (String)field.get("catalog");
                    String schema = (String)field.get("schema");
                    String table = (String)field.get("table");
                    String name = (String)field.get("name");
                    String type = (String)field.get("type");
                    header.add(DSL.field(DSL.name(catalog, schema, table, name), DefaultDataType.getDataType(ctx.dialect(), StringUtils.defaultIfBlank(type, "VARCHAR"))));
                }
            }
            records = (List)o1.get("records");
        } else {
            records = (List)root;
        }
        if (actualRow == null && !header.isEmpty()) {
            actualRow = Tools.row0(header);
        }
        if (actualRow != null) {
            result = new ResultImpl(ctx.configuration(), (AbstractRow)actualRow);
        }
        if (records != null) {
            for (Object o3 : records) {
                Object record;
                if (o3 instanceof Map) {
                    record = (Map)o3;
                    if (result == null) {
                        if (header.isEmpty()) {
                            for (String name : record.keySet()) {
                                header.add(DSL.field(DSL.name(name), SQLDataType.VARCHAR));
                            }
                        }
                        actualRow = Tools.row0(header);
                        result = new ResultImpl(ctx.configuration(), (AbstractRow)actualRow);
                    }
                    List<Object> list = multiset ? JSONReader.patchRecord(ctx, multiset, actualRow, record.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(Map.Entry::getValue).collect(Collectors.toList())) : null;
                    result.add(Tools.newRecord(true, recordType, actualRow, ctx.configuration()).operate(arg_0 -> JSONReader.lambda$read$0(multiset, list, (Map)record, arg_0)));
                    continue;
                }
                record = (List)o3;
                if (result == null) {
                    if (header.isEmpty()) {
                        header.addAll(Arrays.asList(Tools.fields(record.size())));
                    }
                    actualRow = Tools.row0(header);
                    result = new ResultImpl(ctx.configuration(), (AbstractRow)actualRow);
                }
                JSONReader.patchRecord(ctx, multiset, actualRow, (List<Object>)record);
                result.add(Tools.newRecord(true, recordType, actualRow, ctx.configuration()).operate(arg_0 -> JSONReader.lambda$read$1((List)record, arg_0)));
            }
        }
        return result;
    }

    private static final List<Object> patchRecord(DSLContext ctx, boolean multiset, Fields result, List<Object> record) {
        for (int i = 0; i < result.fields().length; ++i) {
            Field<?> field = result.field(i);
            if (field.getType() == byte[].class && record.get(i) instanceof String) {
                record.set(i, DatatypeConverter.parseBase64Binary((String)record.get(i)));
                continue;
            }
            if (!multiset || !field.getDataType().isMultiset()) continue;
            record.set(i, JSONReader.read(ctx, (AbstractRow)field.getDataType().getRow(), field.getDataType().getRecordType(), multiset, record.get(i)));
        }
        return record;
    }

    private static /* synthetic */ Record lambda$read$1(List record, Record r) throws RuntimeException {
        r.from(record);
        return r;
    }

    private static /* synthetic */ Record lambda$read$0(boolean multiset, List list, Map record, Record r) throws RuntimeException {
        if (multiset) {
            r.from(list);
        } else {
            r.fromMap(record);
        }
        return r;
    }
}

