/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function2;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Internal;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;
import java.math.BigDecimal;

final class Power
extends AbstractField<BigDecimal>
implements QOM.Power {
    final Field<? extends Number> base;
    final Field<? extends Number> exponent;

    Power(Field<? extends Number> base, Field<? extends Number> exponent) {
        super(Names.N_POWER, Tools.allNotNull(SQLDataType.NUMERIC, base, exponent));
        this.base = Tools.nullSafeNotNull(base, SQLDataType.INTEGER);
        this.exponent = Tools.nullSafeNotNull(exponent, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: 
            case SQLITE: {
                ctx.visit(DSL.exp(Internal.imul(DSL.ln(this.base), this.exponent)));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_POWER, this.getDataType(), this.base, this.exponent));
            }
        }
    }

    @Override
    public final Field<? extends Number> $arg1() {
        return this.base;
    }

    @Override
    public final Field<? extends Number> $arg2() {
        return this.exponent;
    }

    @Override
    public final QOM.Power $arg1(Field<? extends Number> newValue) {
        return this.constructor().apply((Field<? extends Number>)newValue, (Field<? extends Number>)this.$arg2());
    }

    @Override
    public final QOM.Power $arg2(Field<? extends Number> newValue) {
        return this.constructor().apply((Field<? extends Number>)this.$arg1(), (Field<? extends Number>)newValue);
    }

    @Override
    public final Function2<? super Field<? extends Number>, ? super Field<? extends Number>, ? extends QOM.Power> constructor() {
        return (a1, a2) -> new Power((Field<? extends Number>)a1, (Field<? extends Number>)a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Power) {
            QOM.Power o = (QOM.Power)that;
            return StringUtils.equals(this.$base(), o.$base()) && StringUtils.equals(this.$exponent(), o.$exponent());
        }
        return super.equals(that);
    }
}

