/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.DataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractAggregateFunction;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.math.BigDecimal;

final class RatioToReport
extends AbstractAggregateFunction<BigDecimal>
implements QOM.RatioToReport {
    private final Field<? extends Number> field;

    RatioToReport(Field<? extends Number> field) {
        super(Names.N_RATIO_TO_REPORT, SQLDataType.DECIMAL, field);
        this.field = field;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case SQLITE: 
            case FIREBIRD: 
            case CUBRID: 
            case MARIADB: 
            case MYSQL: 
            case POSTGRES: 
            case YUGABYTEDB: {
                DataType<Number> cast;
                switch (ctx.family()) {
                    case SQLITE: {
                        cast = SQLDataType.DOUBLE;
                        break;
                    }
                    case FIREBIRD: {
                        cast = SQLDataType.DECIMAL(38, 19);
                        break;
                    }
                    default: {
                        cast = SQLDataType.DECIMAL;
                    }
                }
                ctx.visit(Tools.castIfNeeded(this.field, cast)).sql(" / ").visit(DSL.sum(this.field));
                this.acceptOverClause(ctx);
                break;
            }
            default: {
                ctx.visit(Names.N_RATIO_TO_REPORT).sql('(').visit(this.field).sql(')');
                this.acceptOverClause(ctx);
            }
        }
    }

    @Override
    public final Field<? extends Number> $field() {
        return this.field;
    }
}

