/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.ExecuteType;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record;
import io.lumine.mythic.bukkit.utils.lib.jooq.RecordContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.RecordListener;
import io.lumine.mythic.bukkit.utils.lib.jooq.RecordListenerProvider;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.InvocationOrder;
import io.lumine.mythic.bukkit.utils.lib.jooq.exception.ControlFlowSignal;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractRecord;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractScope;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DefaultRecordContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.ThrowingFunction;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.util.Arrays;
import java.util.function.Supplier;

final class RecordDelegate<R extends Record> {
    private final Configuration configuration;
    private final Supplier<R> recordSupplier;
    private final Boolean fetched;
    private final RecordLifecycleType type;

    RecordDelegate(Configuration configuration, Supplier<R> recordSupplier, Boolean fetched) {
        this(configuration, recordSupplier, fetched, RecordLifecycleType.LOAD);
    }

    RecordDelegate(Configuration configuration, Supplier<R> recordSupplier, Boolean fetched, RecordLifecycleType type) {
        this.configuration = configuration;
        this.recordSupplier = recordSupplier;
        this.fetched = fetched;
        this.type = type;
    }

    static final <R extends Record> RecordDelegate<R> delegate(Configuration configuration, R record, RecordLifecycleType type) {
        return new RecordDelegate<Record>(configuration, () -> record, null, type);
    }

    final <E extends Exception> R operate(ThrowingFunction<R, R, E> operation) throws E {
        Exception exception;
        AbstractScope ctx;
        RecordListener[] listeners;
        Record record;
        block31: {
            record = (Record)this.recordSupplier.get();
            if (this.fetched != null && record instanceof AbstractRecord) {
                ((AbstractRecord)record).fetched = this.fetched;
            }
            RecordListenerProvider[] providers = null;
            listeners = null;
            ctx = null;
            exception = null;
            if (this.configuration != null && (providers = this.configuration.recordListenerProviders()) != null && providers.length > 0) {
                listeners = Tools.map(providers, p -> p.provide(), RecordListener[]::new);
                ctx = new DefaultRecordContext(this.configuration, this.executeType(), record);
            }
            if (listeners != null) {
                block20: for (Object listener : ctx == null || ctx.settings().getRecordListenerStartInvocationOrder() != InvocationOrder.REVERSE ? Arrays.asList(listeners) : Tools.reverseIterable(listeners)) {
                    switch (this.type) {
                        case LOAD: {
                            listener.loadStart((RecordContext)((Object)ctx));
                            continue block20;
                        }
                        case REFRESH: {
                            listener.refreshStart((RecordContext)((Object)ctx));
                            continue block20;
                        }
                        case STORE: {
                            listener.storeStart((RecordContext)((Object)ctx));
                            continue block20;
                        }
                        case INSERT: {
                            listener.insertStart((RecordContext)((Object)ctx));
                            continue block20;
                        }
                        case UPDATE: {
                            listener.updateStart((RecordContext)((Object)ctx));
                            continue block20;
                        }
                        case MERGE: {
                            listener.mergeStart((RecordContext)((Object)ctx));
                            continue block20;
                        }
                        case DELETE: {
                            listener.deleteStart((RecordContext)((Object)ctx));
                            continue block20;
                        }
                    }
                    throw new IllegalStateException("Type not supported: " + this.type);
                }
            }
            if (Tools.attachRecords(this.configuration)) {
                record.attach(this.configuration);
            }
            if (operation != null) {
                try {
                    operation.apply(record);
                }
                catch (Exception e) {
                    exception = e;
                    if (e instanceof ControlFlowSignal) break block31;
                    if (ctx != null) {
                        ((DefaultRecordContext)ctx).exception = e;
                    }
                    if (listeners == null) break block31;
                    for (RecordListener listener : listeners) {
                        listener.exception((RecordContext)((Object)ctx));
                    }
                }
            }
        }
        if (listeners != null) {
            block22: for (Object listener : ctx == null || ctx.settings().getRecordListenerEndInvocationOrder() != InvocationOrder.REVERSE ? Arrays.asList(listeners) : Tools.reverseIterable(listeners)) {
                switch (this.type) {
                    case LOAD: {
                        listener.loadEnd((RecordContext)((Object)ctx));
                        continue block22;
                    }
                    case REFRESH: {
                        listener.refreshEnd((RecordContext)((Object)ctx));
                        continue block22;
                    }
                    case STORE: {
                        listener.storeEnd((RecordContext)((Object)ctx));
                        continue block22;
                    }
                    case INSERT: {
                        listener.insertEnd((RecordContext)((Object)ctx));
                        continue block22;
                    }
                    case UPDATE: {
                        listener.updateEnd((RecordContext)((Object)ctx));
                        continue block22;
                    }
                    case MERGE: {
                        listener.mergeEnd((RecordContext)((Object)ctx));
                        continue block22;
                    }
                    case DELETE: {
                        listener.deleteEnd((RecordContext)((Object)ctx));
                        continue block22;
                    }
                }
                throw new IllegalStateException("Type not supported: " + this.type);
            }
        }
        if (exception != null) {
            throw exception;
        }
        return (R)record;
    }

    private final ExecuteType executeType() {
        return this.type == RecordLifecycleType.LOAD || this.type == RecordLifecycleType.REFRESH ? ExecuteType.READ : ExecuteType.WRITE;
    }

    static enum RecordLifecycleType {
        LOAD,
        REFRESH,
        STORE,
        INSERT,
        UPDATE,
        MERGE,
        DELETE;

    }
}

