/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.CommonTableExpression;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function3;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record2;
import io.lumine.mythic.bukkit.utils.lib.jooq.Select;
import io.lumine.mythic.bukkit.utils.lib.jooq.TableLike;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;

final class SplitPart
extends AbstractField<String>
implements QOM.SplitPart {
    final Field<String> string;
    final Field<String> delimiter;
    final Field<? extends Number> n;

    SplitPart(Field<String> string, Field<String> delimiter, Field<? extends Number> n) {
        super(Names.N_SPLIT_PART, Tools.allNotNull(SQLDataType.VARCHAR, string, delimiter, n));
        this.string = Tools.nullSafeNotNull(string, SQLDataType.VARCHAR);
        this.delimiter = Tools.nullSafeNotNull(delimiter, SQLDataType.VARCHAR);
        this.n = Tools.nullSafeNotNull(n, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: {
                ctx.visit(DSL.substring(DSL.substringIndex(this.string, this.delimiter, this.n), DSL.case_(this.n).when((Field<? extends Number>)DSL.one(), DSL.one()).else_(DSL.length(DSL.substringIndex(this.string, this.delimiter, this.n.minus(DSL.one()))).plus(DSL.length(this.delimiter)).plus(DSL.one()))));
                break;
            }
            case HSQLDB: {
                Field<String> rS = DSL.field(DSL.name("s"), String.class);
                Field<Integer> rN = DSL.field(DSL.name("n"), Integer.TYPE);
                Field<String> rD = DSL.field(DSL.name("d"), String.class);
                Field<Integer> rPos = DSL.position(rS, rD);
                Field<Integer> rLen = DSL.length(rD);
                Field<Integer> rPosN = DSL.nullif(rPos, DSL.zero());
                Field<String> rStr = DSL.substring(rS, rPosN.plus(rLen));
                Field<String> rRes = DSL.coalesce(DSL.substring(rS, DSL.one(), rPosN.minus(DSL.one())), rS);
                CommonTableExpression<Record2<String, String>> s1 = DSL.name("s1").fields("s", "d").as(DSL.select(this.string, this.delimiter));
                CommonTableExpression s2 = DSL.name("s2").fields("s", "d", "x", "n").as(DSL.select(rStr, rD, rRes, DSL.one()).from((TableLike<?>)s1).unionAll((Select)DSL.select(rStr, rD, rRes, rN.plus(DSL.one())).from(DSL.name("s2")).where(rS.isNotNull())));
                Tools.visitSubquery(ctx, DSL.withRecursive(s1, s2).select(DSL.coalesce(DSL.max(DSL.field(DSL.name("x"))), DSL.inline(""))).from((TableLike<?>)s2).where(s2.field("n").eq(this.n)));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_SPLIT_PART, this.getDataType(), this.string, this.delimiter, this.n));
            }
        }
    }

    @Override
    public final Field<String> $string() {
        return this.string;
    }

    @Override
    public final Field<String> $delimiter() {
        return this.delimiter;
    }

    @Override
    public final Field<? extends Number> $n() {
        return this.n;
    }

    @Override
    public final QOM.SplitPart $string(Field<String> newValue) {
        return this.constructor().apply(newValue, this.$delimiter(), this.$n());
    }

    @Override
    public final QOM.SplitPart $delimiter(Field<String> newValue) {
        return this.constructor().apply(this.$string(), newValue, this.$n());
    }

    @Override
    public final QOM.SplitPart $n(Field<? extends Number> newValue) {
        return this.constructor().apply(this.$string(), this.$delimiter(), newValue);
    }

    public final Function3<? super Field<String>, ? super Field<String>, ? super Field<? extends Number>, ? extends QOM.SplitPart> constructor() {
        return (a1, a2, a3) -> new SplitPart((Field<String>)a1, (Field<String>)a2, (Field<? extends Number>)a3);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.SplitPart) {
            QOM.SplitPart o = (QOM.SplitPart)that;
            return StringUtils.equals(this.$string(), o.$string()) && StringUtils.equals(this.$delimiter(), o.$delimiter()) && StringUtils.equals(this.$n(), o.$n());
        }
        return super.equals(that);
    }
}

