/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function2;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Internal;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;
import java.math.BigDecimal;
import java.math.MathContext;

final class Trunc<T extends Number>
extends AbstractField<T>
implements QOM.Trunc<T> {
    final Field<T> value;
    final Field<Integer> decimals;

    Trunc(Field<T> value, Field<Integer> decimals) {
        super(Names.N_TRUNC, Tools.allNotNull(Tools.dataType(SQLDataType.INTEGER, value, false), value, decimals));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.INTEGER);
        this.decimals = Tools.nullSafeNotNull(decimals, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: {
                Integer decimalsVal = Tools.extractParamValue(this.decimals);
                Field<BigDecimal> power = decimalsVal != null ? DSL.inline(BigDecimal.TEN.pow(decimalsVal, MathContext.DECIMAL128)) : DSL.power(DSL.inline(BigDecimal.TEN), this.decimals);
                ctx.visit(DSL.decode().when(this.value.sign().greaterOrEqual(DSL.zero()), Internal.idiv(Internal.imul(this.value, power).floor(), power)).otherwise(Internal.idiv(Internal.imul(this.value, power).ceil(), power)));
                break;
            }
            case H2: 
            case MARIADB: 
            case MYSQL: {
                ctx.visit(Names.N_TRUNCATE).sql('(').visit(this.value).sql(", ").visit(this.decimals).sql(')');
                break;
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                ctx.visit(Tools.castIfNeeded(DSL.function(Names.N_TRUNC, SQLDataType.NUMERIC, Tools.castIfNeeded(this.value, SQLDataType.NUMERIC), this.decimals), this.value.getDataType()));
                break;
            }
            default: {
                ctx.visit(Names.N_TRUNC).sql('(').visit(this.value).sql(", ").visit(this.decimals).sql(')');
            }
        }
    }

    @Override
    public final Field<T> $value() {
        return this.value;
    }

    @Override
    public final Field<Integer> $decimals() {
        return this.decimals;
    }

    @Override
    public final QOM.Trunc<T> $value(Field<T> newValue) {
        return this.constructor().apply(newValue, this.$decimals());
    }

    @Override
    public final QOM.Trunc<T> $decimals(Field<Integer> newValue) {
        return this.constructor().apply(this.$value(), newValue);
    }

    public final Function2<? super Field<T>, ? super Field<Integer>, ? extends QOM.Trunc<T>> constructor() {
        return (a1, a2) -> new Trunc(a1, (Field<Integer>)a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Trunc) {
            QOM.Trunc o = (QOM.Trunc)that;
            return StringUtils.equals(this.$value(), o.$value()) && StringUtils.equals(this.$decimals(), o.$decimals());
        }
        return super.equals(that);
    }
}

