/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.numbers;

import org.bukkit.util.Vector;
import org.joml.Quaterniond;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3f;

public final class Maths {
    public static final float PI = (float)Math.PI;
    public static final double TAU = Math.PI * 2;
    public static final double PI_2 = 1.5707963267948966;
    public static final double PI_4 = 0.7853981633974483;
    public static final double EPSILON = 1.0E-5;
    public static final float DEG2RAD = (float)Math.PI / 180;
    public static final float RAD2DEG = 57.29578f;
    protected static double movementResolution;
    private static final int SIN_BITS;
    private static final int SIN_MASK;
    private static final int SIN_COUNT;
    private static final float radFull;
    private static final float radToIndex;
    private static final float degFull;
    private static final float degToIndex;
    private static final float DISTANCE = 0.5f;
    private static final float[] sin;
    private static final float[] cos;

    public static float sin(float rad) {
        return sin[(int)(rad * radToIndex) & SIN_MASK];
    }

    public static float cos(float rad) {
        return cos[(int)(rad * radToIndex) & SIN_MASK];
    }

    public static float toRadians(double degree) {
        return (float)org.joml.Math.toRadians((double)degree);
    }

    public static boolean isSimilar(float a, float b) {
        return (double)org.joml.Math.abs((float)(b - a)) < 1.0E-5;
    }

    public static boolean isSimilar(Vector a, Vector b) {
        return org.joml.Math.abs((double)(b.getX() - a.getX())) < movementResolution && org.joml.Math.abs((double)(b.getY() - a.getY())) < movementResolution && org.joml.Math.abs((double)(b.getZ() - a.getZ())) < movementResolution;
    }

    public static Vector3f getEulerAnglesZYX(Quaternionf quaternionf, Vector3f eulerAngles) {
        float w = quaternionf.w;
        float x = quaternionf.x;
        float y = quaternionf.y;
        float z = quaternionf.z;
        eulerAngles.x = org.joml.Math.atan2((float)(2.0f * (y * z + x * w)), (float)(z * z - y * y - x * x + w * w));
        eulerAngles.y = org.joml.Math.safeAsin((float)(-2.0f * (x * z - w * y)));
        eulerAngles.z = org.joml.Math.atan2((float)(x * y + w * z), (float)(0.5f - y * y - z * z));
        return eulerAngles;
    }

    public static Vector3d getEulerAnglesZYX(Quaterniond quaterniond, Vector3d eulerAngles) {
        double w = quaterniond.w;
        double x = quaterniond.x;
        double y = quaterniond.y;
        double z = quaterniond.z;
        eulerAngles.x = org.joml.Math.atan2((double)(2.0 * (y * z + x * w)), (double)(z * z - y * y - x * x + w * w));
        eulerAngles.y = org.joml.Math.safeAsin((double)(-2.0 * (x * z - w * y)));
        eulerAngles.z = org.joml.Math.atan2((double)(x * y + w * z), (double)(0.5 - y * y - z * z));
        return eulerAngles;
    }

    private Maths() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    static {
        int i;
        movementResolution = 0.001;
        SIN_BITS = 12;
        SIN_MASK = ~(-1 << SIN_BITS);
        SIN_COUNT = SIN_MASK + 1;
        radFull = (float)Math.PI * 2;
        degFull = 360.0f;
        radToIndex = (float)SIN_COUNT / radFull;
        degToIndex = (float)SIN_COUNT / degFull;
        sin = new float[SIN_COUNT];
        cos = new float[SIN_COUNT];
        for (i = 0; i < SIN_COUNT; ++i) {
            Maths.sin[i] = org.joml.Math.sin((float)(((float)i + 0.5f) / (float)SIN_COUNT * radFull));
            Maths.cos[i] = org.joml.Math.cos((float)(((float)i + 0.5f) / (float)SIN_COUNT * radFull));
        }
        for (i = 0; i < 360; i += 90) {
            Maths.sin[(int)((float)i * Maths.degToIndex) & Maths.SIN_MASK] = (float)org.joml.Math.sin((double)((double)i * Math.PI / 180.0));
            Maths.cos[(int)((float)i * Maths.degToIndex) & Maths.SIN_MASK] = (float)org.joml.Math.cos((double)((double)i * Math.PI / 180.0));
        }
    }
}

