/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.permissions;

import io.lumine.mythic.bukkit.utils.Schedulers;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.PermissionNode;
import org.bukkit.entity.Player;

public final class Permissions {
    public static final LuckPerms getLuckPerms() {
        return LuckPermsProvider.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean has(Player player, String permission) {
        if (!player.isOnline()) {
            return false;
        }
        boolean op = player.isOp();
        try {
            if (op) {
                player.setOp(false);
            }
            boolean bl = player.hasPermission(permission);
            return bl;
        }
        finally {
            if (op) {
                player.setOp(true);
            }
        }
    }

    public void addTransient(Player player, String permission) {
        this.addTransient(player, (Node)PermissionNode.builder((String)permission).build());
    }

    public void addTransient(Player player, Node node) {
        Schedulers.async().run(() -> {
            User user = Permissions.getLuckPerms().getUserManager().getUser(player.getUniqueId());
            user.transientData().add(node);
        });
    }

    public void removeTransient(Player player, String permission) {
        this.removeTransient(player, (Node)PermissionNode.builder((String)permission).build());
    }

    public void removeTransient(Player player, Node node) {
        LuckPerms lp = LuckPermsProvider.get();
        Schedulers.async().run(() -> {
            User user = lp.getUserManager().getUser(player.getUniqueId());
            user.transientData().remove(node);
        });
    }

    private Permissions() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

