/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.serialize;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.lumine.mythic.bukkit.utils.gson.GsonSerializable;
import io.lumine.mythic.bukkit.utils.gson.JsonBuilder;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.bukkit.Location;

public final class Direction
implements GsonSerializable {
    public static final Direction ZERO = Direction.of(0.0f, 0.0f);
    private final float yaw;
    private final float pitch;

    public static Direction deserialize(String element) {
        Preconditions.checkNotNull((Object)element);
        String[] values = element.split(",");
        float yaw = Float.parseFloat(values[0]);
        float pitch = Float.parseFloat(values[1]);
        return Direction.of(yaw, pitch);
    }

    public static Direction deserialize(JsonElement element) {
        Preconditions.checkArgument((boolean)element.isJsonObject());
        JsonObject object = element.getAsJsonObject();
        Preconditions.checkArgument((boolean)object.has("yaw"));
        Preconditions.checkArgument((boolean)object.has("pitch"));
        float yaw = object.get("yaw").getAsFloat();
        float pitch = object.get("pitch").getAsFloat();
        return Direction.of(yaw, pitch);
    }

    public static Direction of(float yaw, float pitch) {
        return new Direction(yaw, pitch);
    }

    public static Direction from(Location location) {
        Objects.requireNonNull(location, "location");
        return Direction.of(location.getYaw(), location.getPitch());
    }

    private Direction(float yaw, float pitch) {
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public Direction round() {
        return this.round(2);
    }

    public Direction round(int places) {
        float yaw = (float)Numbers.round(this.yaw, places);
        float pitch = (float)Numbers.round(this.pitch, places);
        return Direction.of(yaw, pitch);
    }

    @Nonnull
    public JsonObject serialize() {
        return JsonBuilder.object().add("yaw", Float.valueOf(this.yaw)).add("pitch", Float.valueOf(this.pitch)).build();
    }

    public String serializeShortForm() {
        return this.yaw + "," + this.pitch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Direction)) {
            return false;
        }
        Direction other = (Direction)o;
        return Float.compare(this.getYaw(), other.getYaw()) == 0 && Float.compare(this.getPitch(), other.getPitch()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        return result;
    }

    public String toString() {
        return "Direction(yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ")";
    }
}

