/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.drops;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.Optional;
import org.bukkit.inventory.ItemStack;

public class DropMetadataImpl
implements DropMetadata,
Cloneable,
PlaceholderMeta {
    private final Optional<SkillCaster> dropper;
    private final Optional<AbstractEntity> cause;
    private Optional<ItemStack> item;
    private float amount = 0.0f;
    private int generations = 0;

    public DropMetadataImpl(SkillCaster dropper, AbstractEntity killer) {
        this.dropper = Optional.ofNullable(dropper);
        this.cause = Optional.ofNullable(killer);
    }

    @Override
    public int tick() {
        return this.generations++;
    }

    @Override
    public SkillCaster getCaster() {
        return this.dropper.isPresent() ? this.dropper.get() : null;
    }

    @Override
    public AbstractEntity getTrigger() {
        return this.cause.isPresent() ? this.cause.get() : null;
    }

    @Override
    public void setItem(ItemStack item) {
        this.item = Optional.ofNullable(item);
    }

    @Override
    public Optional<SkillCaster> getDropper() {
        return this.dropper;
    }

    @Override
    public Optional<AbstractEntity> getCause() {
        return this.cause;
    }

    @Override
    public Optional<ItemStack> getItem() {
        return this.item;
    }

    @Override
    public float getAmount() {
        return this.amount;
    }

    @Override
    public int getGenerations() {
        return this.generations;
    }

    @Override
    public void setAmount(float amount) {
        this.amount = amount;
    }

    public void setGenerations(int generations) {
        this.generations = generations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DropMetadataImpl)) {
            return false;
        }
        DropMetadataImpl other = (DropMetadataImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        if (this.getGenerations() != other.getGenerations()) {
            return false;
        }
        Optional<SkillCaster> this$dropper = this.getDropper();
        Optional<SkillCaster> other$dropper = other.getDropper();
        if (this$dropper == null ? other$dropper != null : !((Object)this$dropper).equals(other$dropper)) {
            return false;
        }
        Optional<AbstractEntity> this$cause = this.getCause();
        Optional<AbstractEntity> other$cause = other.getCause();
        if (this$cause == null ? other$cause != null : !((Object)this$cause).equals(other$cause)) {
            return false;
        }
        Optional<ItemStack> this$item = this.getItem();
        Optional<ItemStack> other$item = other.getItem();
        return !(this$item == null ? other$item != null : !((Object)this$item).equals(other$item));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DropMetadataImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getAmount());
        result = result * 59 + this.getGenerations();
        Optional<SkillCaster> $dropper = this.getDropper();
        result = result * 59 + ($dropper == null ? 43 : ((Object)$dropper).hashCode());
        Optional<AbstractEntity> $cause = this.getCause();
        result = result * 59 + ($cause == null ? 43 : ((Object)$cause).hashCode());
        Optional<ItemStack> $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : ((Object)$item).hashCode());
        return result;
    }

    public String toString() {
        return "DropMetadataImpl(dropper=" + this.getDropper() + ", cause=" + this.getCause() + ", item=" + this.getItem() + ", amount=" + this.getAmount() + ", generations=" + this.getGenerations() + ")";
    }
}

