/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.glow;

import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.events.MythicPlayerLoadedEvent;
import io.lumine.mythic.bukkit.events.MythicRemoveEntityPacket;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.glow.GlowColor;
import io.lumine.mythic.core.glow.GlowData;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class GlowManager
extends ReloadableModule<MythicBukkit> {
    private final Map<Integer, GlowData> glowingEntities = new ConcurrentHashMap<Integer, GlowData>();

    public GlowManager(MythicBukkit plugin) {
        super(plugin, false);
        this.load(plugin);
    }

    @Override
    public void load(MythicBukkit plugin) {
        Events.subscribe(MythicPlayerLoadedEvent.class).handler(event -> plugin.getVolatileCodeHandler().getEntityHandler().initTeams(event.getPlayerData().getEntity())).bindWith(this);
        if (ServerVersion.isPaper()) {
            Events.subscribe(EntityRemoveFromWorldEvent.class).handler(event -> this.glowingEntities.remove(event.getEntity().getEntityId())).bindWith(this);
        } else {
            Events.subscribe(MythicRemoveEntityPacket.class).handler(event -> this.glowingEntities.remove(event.getId())).bindWith(this);
        }
    }

    @Override
    public void unload() {
    }

    public void setGlowing(AbstractEntity glowingEntity, GlowColor color, Collection<AbstractPlayer> receivers) {
        receivers.forEach(player -> this.setGlowing(glowingEntity, color, (AbstractPlayer)player));
    }

    public void setGlowing(AbstractEntity glowingEntity, GlowColor color, AbstractPlayer receiver) {
        this.glowingEntities.putIfAbsent(glowingEntity.getEntityId(), new GlowData(new ConcurrentHashMap<UUID, GlowColor>()));
        if (color != null) {
            this.getGlowData(glowingEntity).set(receiver, color);
            ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setGlowing(glowingEntity, true, receiver);
        } else {
            ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setGlowing(glowingEntity, false, receiver);
            this.getGlowData(glowingEntity).remove(receiver);
        }
    }

    public GlowData getGlowData(int entity) {
        return this.glowingEntities.get(entity);
    }

    public GlowData getGlowData(AbstractEntity entity) {
        return this.getGlowData(entity.getEntityId());
    }
}

