/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus.items.editor;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.menu.Icon;
import io.lumine.mythic.bukkit.utils.menu.IconBuilder;
import io.lumine.mythic.bukkit.utils.prompts.chat.ChatPrompt;
import io.lumine.mythic.bukkit.utils.serialize.Chroma;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.menus.items.ItemEditorButton;
import io.lumine.mythic.core.menus.items.ItemEditorButtons;
import io.lumine.mythic.core.menus.items.ItemEditorMenuContext;
import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EditColorButton
extends ItemEditorButton {
    private static final Collection<Material> COLORABLE = Sets.newHashSet((Object[])new Material[]{Material.LEATHER_HORSE_ARMOR, Material.LEATHER_HELMET, Material.LEATHER_CHESTPLATE, Material.LEATHER_LEGGINGS, Material.LEATHER_BOOTS, Material.POTION, Material.LINGERING_POTION, Material.SPLASH_POTION, Material.SHIELD});

    public EditColorButton(ItemEditorButtons parent, int sort) {
        super(parent, sort);
    }

    @Override
    public boolean isApplicable(MythicItem mythicItem) {
        return COLORABLE.contains(mythicItem.getMaterial());
    }

    @Override
    public Icon<ItemEditorMenuContext> getIcon() {
        return IconBuilder.create().material(Material.RED_DYE).name("<green>Set Color").lore(context -> Lists.newArrayList((Object[])new String[]{"&c", "<yellow>Current: <" + context.getItem().getColor().get().toHexString() + ">" + context.getItem().getColor().get().toHexString()})).click((context, player) -> {
            CommandHelper.sendEditorMessage((CommandSender)player, "Type in the Color you'd like to use.", "Type cancel to abort editing.");
            player.closeInventory();
            ChatPrompt.listen(player, input -> {
                if (input.equalsIgnoreCase("cancel")) {
                    return ChatPrompt.Response.ACCEPTED;
                }
                try {
                    Chroma color = Chroma.of(input);
                    if (color == null) {
                        CommandHelper.sendError((CommandSender)player, "Invalid color format supplied");
                        return ChatPrompt.Response.TRY_AGAIN;
                    }
                    MythicItem item = context.getItem();
                    item.getConfig().setSave("Options.Color", color.serializeShortForm());
                    item.loadItem();
                    item.buildItemCache();
                }
                catch (Throwable ex) {
                    CommandHelper.sendError((CommandSender)player, "Invalid color format supplied");
                    return ChatPrompt.Response.TRY_AGAIN;
                }
                return ChatPrompt.Response.ACCEPTED;
            }).thenAcceptSync(in -> context.openMenu((Player)player));
        }).build();
    }
}

