/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.mobs;

import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.volatilecode.VolatileMaterial;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.utils.adventure.text.serializer.gson.GsonComponentSerializer;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.utils.jnbt.CompoundTag;
import io.lumine.mythic.core.utils.jnbt.CompoundTagBuilder;
import io.lumine.mythic.core.utils.jnbt.ListTagBuilder;
import io.lumine.mythic.core.utils.jnbt.StringTag;
import org.bukkit.ChatColor;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class EggManager {
    public static boolean giveMythicEgg(MythicMob mm4, Player player, int amount) {
        BukkitItemStack bukkitEgg = new BukkitItemStack(VolatileMaterial.SPAWN_EGG);
        String displayName = mm4.getEggDisplay() + " Spawn Egg";
        String[] lore = new String[]{"<dark_gray>A Mythical Egg that can</dark_gray>", "<dark_gray>be used to resurrect a</dark_gray>", "<dark_gray>" + mm4.getEggDisplay() + "</dark_gray>"};
        bukkitEgg.enchant(Enchantment.DURABILITY, 10);
        bukkitEgg.amount(amount);
        ItemStack egg = bukkitEgg.build().clone();
        CompoundTagBuilder compoundTag = MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().getNBTData(egg).createBuilder();
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            CompoundTagBuilder displayTag = CompoundTagBuilder.create();
            displayTag.putString("Name", (String)GsonComponentSerializer.gson().serialize(Text.parse(displayName)));
            ListTagBuilder loreBuilder = ListTagBuilder.create(StringTag.class);
            for (String str : lore) {
                loreBuilder.add(new StringTag((String)GsonComponentSerializer.gson().serialize(Text.parse(str))));
            }
            displayTag.put("Lore", loreBuilder.build());
            compoundTag.put("display", displayTag.build());
        }
        compoundTag.putString("MYTHIC_EGG", mm4.getInternalName());
        egg = MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().setNBTData(egg, compoundTag.build());
        player.getInventory().addItem(new ItemStack[]{egg});
        return true;
    }

    public static MythicMob getMythicMobFromEgg(ItemStack eggItem) {
        CompoundTag eggTag = MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().getNBTData(eggItem);
        if (eggTag.containsKey("MYTHIC_EGG")) {
            String mmType = eggTag.getString("MYTHIC_EGG");
            return MythicBukkit.inst().getMobManager().getMythicMob(mmType).orElseGet(() -> null);
        }
        return null;
    }

    @Deprecated
    public static MythicMob getMythicMobFromEgg(String s2) {
        for (MythicMob MM : MythicBukkit.inst().getMobManager().getMobTypes()) {
            String search = ChatColor.DARK_GRAY + ChatColor.ITALIC + MM.getInternalName();
            if (!search.equals(s2)) continue;
            return MM;
        }
        return null;
    }
}

