/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.mobs;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.MobManager;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.mobs.entities.MythicEntityType;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.config.properties.types.NodeListProp;
import io.lumine.mythic.bukkit.utils.files.Files;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.core.config.IOHandler;
import io.lumine.mythic.core.config.IOLoader;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.constants.MobKeys;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.CasterRegistry;
import io.lumine.mythic.core.mobs.MobRegistry;
import io.lumine.mythic.core.mobs.MobStack;
import io.lumine.mythic.core.mobs.MobType;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.TriggeredSkill;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import io.lumine.mythic.core.utils.TemplateUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

public class MobExecutor
extends ReloadableModule<MythicBukkit>
implements MobManager,
CasterRegistry {
    private static final String FOLDER_MOBS = "Mobs";
    private Map<String, MythicMob> mmList = Maps.newConcurrentMap();
    private Map<String, MythicMob> mmDisplayLookup = Maps.newConcurrentMap();
    private List<MobStack> listMobStacks = Lists.newArrayList();
    private Map<MythicEntityType, MythicMob> mmDefaultList = Maps.newConcurrentMap();
    private MobRegistry mobRegistry;
    private transient Map<UUID, ActiveMob> activeMobsInCombat = Maps.newConcurrentMap();
    private transient Cache<UUID, Boolean> mmVoidList = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<UUID, Boolean>(){

        public Boolean load(UUID uuid) {
            return true;
        }
    });
    public static boolean spawnflag = false;
    public static boolean mountflag = false;

    public MobExecutor(MythicBukkit plugin) {
        super(plugin);
    }

    @Override
    public void load(MythicBukkit plugin) {
        if (this.mobRegistry == null) {
            this.mobRegistry = new MobRegistry();
        }
    }

    @Override
    public void unload() {
    }

    public void loadMobs() {
        IOLoader<MythicBukkit> defaultMobs = new IOLoader<MythicBukkit>(MythicBukkit.inst(), "VanillaMobs.yml", FOLDER_MOBS);
        defaultMobs = new IOLoader<MythicBukkit>(MythicBukkit.inst(), "ExampleMobs.yml", FOLDER_MOBS);
        List<File> mobFiles = IOHandler.getAllFiles(defaultMobs.getFile().getParent());
        List<IOLoader<MythicBukkit>> mobLoaders = IOHandler.getSaveLoad(MythicBukkit.inst(), mobFiles, FOLDER_MOBS);
        this.mmList.clear();
        this.mmDefaultList.clear();
        this.mmDisplayLookup.clear();
        this.listMobStacks.clear();
        ArrayList mobsUsingTemplates = Lists.newArrayList();
        for (Pack pack : ((MythicBukkit)this.plugin).getPackManager().getPacks()) {
            File folder = pack.getPackFolder(FOLDER_MOBS);
            if (!folder.exists() || !folder.isDirectory()) continue;
            for (File file : Files.getAll(folder.getAbsolutePath(), Lists.newArrayList((Object[])new String[]{"yml", "txt"}))) {
                MythicConfigImpl fileConfig = new MythicConfigImpl(file);
                for (String node : NodeListProp.getNodes(file, "")) {
                    try {
                        MythicConfig config = fileConfig.getNestedConfig(node);
                        if (BukkitEntityType.getMythicEntity(node) != null) {
                            MythicEntityType met = MythicEntityType.get(node);
                            MobType mm4 = new MobType(this, pack, file, node, config);
                            this.mmDefaultList.put(met, mm4);
                            this.mmList.put(met.toString(), mm4);
                            continue;
                        }
                        if (config.getString("MobStack") != null) {
                            String stack = config.getString("MobStack");
                            this.listMobStacks.add(new MobStack(node, stack, file.getAbsolutePath()));
                            continue;
                        }
                        String display = config.getString(new String[]{"Display", "DisplayName"});
                        String maybeTemplate = config.getString("Template");
                        if (maybeTemplate == null) {
                            maybeTemplate = config.getString("Templates");
                        }
                        if (maybeTemplate != null) {
                            TemplateUtil.TemplateMob tmpl = new TemplateUtil.TemplateMob(file, pack, node, (MythicConfigImpl)config, display, maybeTemplate);
                            mobsUsingTemplates.add(tmpl);
                            continue;
                        }
                        MobType mm5 = new MobType(this, pack, file, node, config);
                        this.mmList.put(node, mm5);
                        if (display == null) continue;
                        this.mmDisplayLookup.put(display, mm5);
                    }
                    catch (Exception ex) {
                        MythicLogger.error("Error loading mob '" + node + "'. Enable debugging for a stack trace.");
                        MythicLogger.handleMinorError(ex);
                    }
                }
            }
        }
        TemplateUtil.handleTemplates(mobsUsingTemplates, this.mmList);
    }

    @Override
    public Collection<MythicMob> getMobTypes() {
        return this.mmList.values();
    }

    @Override
    public Collection<String> getMobNames() {
        return this.mmList.keySet();
    }

    @Override
    public Collection<MythicMob> getVanillaTypes() {
        return this.mmDefaultList.values();
    }

    @Override
    public Optional<MythicMob> getVanillaType(MythicEntityType type) {
        return Optional.ofNullable(this.mmDefaultList.getOrDefault((Object)type, null));
    }

    @Override
    public Collection<MobStack> getMobStacks() {
        return this.listMobStacks;
    }

    @Override
    public Optional<SkillCaster> getSkillCaster(UUID uuid) {
        return Optional.ofNullable(this.mobRegistry.get(uuid));
    }

    @Override
    public Collection<ActiveMob> getActiveMobs() {
        return this.mobRegistry.values();
    }

    public Collection<ActiveMob> getActiveMobs(Predicate<ActiveMob> predicate) {
        ArrayList mobs = Lists.newArrayList();
        for (ActiveMob mob : this.mobRegistry.values()) {
            if (!predicate.test(mob)) continue;
            mobs.add(mob);
        }
        return mobs;
    }

    @Override
    public Collection<ActiveMob> getActiveMobsInCombat() {
        return this.activeMobsInCombat.values();
    }

    @Deprecated
    public boolean isLoadedMob(AbstractEntity entity) {
        return this.isLoadedMob(entity.getUniqueId());
    }

    @Deprecated
    public boolean isLoadedMob(UUID uuid) {
        return this.isActiveMob(uuid);
    }

    public boolean isMythicMob(Entity entity) {
        return entity.getPersistentDataContainer().has(MobKeys.TYPE, PersistentDataType.STRING);
    }

    public boolean isMythicMob(AbstractEntity entity) {
        return entity.getDataContainer().has(MobKeys.TYPE, PersistentDataType.STRING);
    }

    public boolean isActiveMob(AbstractEntity entity) {
        return this.isActiveMob(entity.getUniqueId());
    }

    public boolean isActiveMob(UUID uuid) {
        return this.mobRegistry.isActiveMob(uuid);
    }

    public Optional<ActiveMob> getActiveMob(UUID uuid) {
        return this.mobRegistry.getActiveMob(uuid);
    }

    public Set<UUID> getVoidList() {
        return this.mmVoidList.asMap().keySet();
    }

    public void setIgnoreEntity(UUID uuid) {
        this.mmVoidList.put((Object)uuid, (Object)true);
    }

    public boolean isIgnoredEntity(UUID uuid) {
        return this.mmVoidList.asMap().keySet().contains(uuid);
    }

    public int removeAllMobs() {
        int amount = 0;
        for (ActiveMob am : this.mobRegistry.values()) {
            if (am.getType() != null && !am.getDespawnMode().getObeysKillCommand().booleanValue()) continue;
            am.setDespawned();
            this.unregisterActiveMob(am);
            am.getEntity().remove();
            ++amount;
        }
        return amount;
    }

    public int removeAllAllMobs() {
        int amount = 0;
        for (ActiveMob am : this.mobRegistry.values()) {
            am.setDespawned();
            this.unregisterActiveMob(am);
            am.getEntity().remove();
            ++amount;
        }
        return amount;
    }

    public int despawnAllMobs() {
        int amount = 0;
        for (ActiveMob am : this.mobRegistry.values()) {
            if (!am.getDespawnMode().getObeysKillCommand().booleanValue()) continue;
            am.setDespawnedSync();
            MythicBukkit.inst().getMobManager().unregisterActiveMob(am);
            if (am.getEntity() != null) {
                am.getEntity().remove();
            }
            ++amount;
        }
        return amount;
    }

    public void setEntityDespawned(UUID uniqueId) {
        this.mobRegistry.getActiveMob(uniqueId).ifPresent(mob -> mob.setDespawned());
    }

    public void ScanWorld() {
        Schedulers.async().run(() -> {
            for (ActiveMob am : this.getActiveMobs()) {
                if (!am.isDead()) continue;
                am.setDespawned();
            }
        });
    }

    public ActiveMob registerActiveMob(ActiveMob am) {
        this.mobRegistry.put(am.getUniqueId(), am);
        return am;
    }

    public ActiveMob registerActiveMob(AbstractEntity l, MythicMob mm4, double level) {
        if (this.isActiveMob(l)) {
            return this.getMythicMobInstance(l);
        }
        ActiveMob am = new ActiveMob(l, mm4, level);
        this.mobRegistry.put(l.getUniqueId(), am);
        mm4.applyMobVolatileOptions(am);
        new TriggeredSkill(SkillTriggers.SPAWN, am, null);
        return am;
    }

    public Optional<ActiveMob> loadMythicMob(Entity entity) {
        return this.loadMythicMob(BukkitAdapter.adapt(entity));
    }

    public Optional<ActiveMob> loadMythicMob(AbstractEntity entity) {
        ActiveMob am = new ActiveMob(entity);
        if (am.validateLoadedMob()) {
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Loaded Mob {0} from PersistentData", entity.getUniqueId());
            this.registerActiveMob(am);
            am.loadSaved();
            return Optional.of(am);
        }
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Failed to load {0} from PersistentData", entity.getUniqueId());
        this.mmVoidList.put((Object)entity.getUniqueId(), (Object)true);
        return Optional.empty();
    }

    public void unregisterActiveMob(UUID u) {
        this.mobRegistry.removeMob(u);
        this.activeMobsInCombat.remove(u);
    }

    public void unregisterActiveMob(ActiveMob am) {
        this.unregisterActiveMob(am.getUniqueId());
    }

    public ActiveMob getMythicMobInstance(Entity target) {
        return this.getMythicMobInstance(BukkitAdapter.adapt(target));
    }

    public ActiveMob getMythicMobInstance(AbstractEntity target) {
        Optional<ActiveMob> maybeMob;
        ActiveMob am = this.mobRegistry.get(target.getUniqueId());
        if (am != null) {
            this.resetActiveMobEntity(am, target);
            return am;
        }
        if (this.isMythicMob(target) && (maybeMob = this.loadMythicMob(target)).isPresent()) {
            return maybeMob.get();
        }
        return null;
    }

    public void verifyMythicMobInstance(AbstractEntity e) {
        ActiveMob am = this.mobRegistry.get(e.getUniqueId());
        if (am != null) {
            this.resetActiveMobEntity(am, e);
        }
    }

    private void resetActiveMobEntity(ActiveMob am, AbstractEntity e) {
        if ((am.getEntity() == null || !am.getEntity().isValid()) && e != null && e.isValid()) {
            am.setEntity(e);
        }
    }

    @Override
    public boolean isMythicMobSpawning() {
        return spawnflag;
    }

    public ActiveMob spawnMob(String type, Location loc) {
        return this.spawnMob(type, BukkitAdapter.adapt(loc), SpawnReason.OTHER, 1.0);
    }

    public ActiveMob spawnMob(String type, Location loc, double level) {
        return this.spawnMob(type, BukkitAdapter.adapt(loc), SpawnReason.OTHER, level);
    }

    public ActiveMob spawnMob(String type, AbstractLocation loc) {
        return this.spawnMob(type, loc, SpawnReason.OTHER, 1.0);
    }

    public ActiveMob spawnMob(String type, AbstractLocation loc, double level) {
        return this.spawnMob(type, loc, SpawnReason.OTHER, level);
    }

    public ActiveMob spawnMob(String type, AbstractLocation loc, SpawnReason reason, double level) {
        return this.spawnMob(type, loc, reason, level, null);
    }

    public ActiveMob spawnMob(String type, AbstractLocation loc, SpawnReason reason, double level, MythicSpawner spawner) {
        MythicMob mm4 = this.getMythicMob(type).orElseGet(() -> null);
        if (mm4 != null) {
            return mm4.spawn(loc, level, reason, null, spawner);
        }
        MobStack ms = this.getMythicMobStack(type);
        if (ms != null) {
            return ms.spawn(loc, level, reason, spawner);
        }
        return null;
    }

    public void SetupMythicMobCompat(LivingEntity l, MythicMob mm4) {
        if (spawnflag) {
            return;
        }
        if (mm4.getMythicEntity() != null) {
            l = (LivingEntity)mm4.getMythicEntity().applyOptions((Entity)l);
        }
        AbstractEntity abstractEntity = BukkitAdapter.adapt((Entity)l);
        ((MythicBukkit)this.getPlugin()).getMobManager();
        ActiveMob am = new ActiveMob(abstractEntity, mm4, MobExecutor.getMythicMobLevel(mm4, BukkitAdapter.adapt((Entity)l)));
        this.mobRegistry.put(l.getUniqueId(), am);
        l = (LivingEntity)mm4.applyMobOptions(am, am.getLevel());
        l = (LivingEntity)mm4.applyMobVolatileOptions(am);
        new TriggeredSkill(SkillTriggers.SPAWN, am, null);
    }

    public static AbstractLocation findSafeSpawnLocation(AbstractLocation b, double radiusXZ, double radiusY, int mob_height, boolean Ymod, boolean onSurface) {
        Location base = BukkitAdapter.adapt(b);
        if (radiusXZ <= 0.0) {
            radiusXZ = 1.0;
        }
        if (radiusY < 0.0) {
            radiusY = 0.0;
        }
        double x = base.getX() - radiusXZ + Numbers.randomDouble() * (radiusXZ * 2.0);
        double z = base.getZ() - radiusXZ + Numbers.randomDouble() * (radiusXZ * 2.0);
        double y = radiusY == 0.0 ? base.getY() : (Ymod ? base.getY() - radiusY + Numbers.randomDouble() * (radiusY * 2.0) : base.getY() + Numbers.randomDouble() * radiusY);
        Location loc = new Location(base.getWorld(), x, y, z);
        if (loc.getBlock().getType().isSolid()) {
            int j = 10;
            while (loc.getBlock().getType().isSolid()) {
                x = base.getX() - radiusXZ + Numbers.randomDouble() * (radiusXZ * 2.0);
                z = base.getZ() - radiusXZ + Numbers.randomDouble() * (radiusXZ * 2.0);
                y = radiusY == 0.0 ? base.getY() : (Ymod ? base.getY() - radiusY + Numbers.randomDouble() * (radiusY * 2.0) : base.getY() + Numbers.randomDouble() * radiusY);
                loc = new Location(base.getWorld(), x, y, z);
                if (--j != 0) continue;
                loc = new Location(base.getWorld(), base.getX(), base.getY() + 1.0, base.getZ());
                break;
            }
        }
        if (onSurface && !loc.getBlock().getRelative(BlockFace.DOWN).getType().isSolid()) {
            int highestY = loc.getWorld().getHighestBlockYAt(loc);
            if ((double)highestY <= loc.getY()) {
                loc.setY((double)(highestY + 1));
            } else {
                int j = 10;
                while (!loc.getBlock().getRelative(BlockFace.DOWN).getType().isSolid()) {
                    if (j == 0) {
                        loc = new Location(base.getWorld(), base.getX(), base.getY() + 1.0, base.getZ());
                        break;
                    }
                    loc.setY(loc.getY() - 1.0);
                    --j;
                }
            }
        }
        return BukkitAdapter.adapt(loc);
    }

    public static AbstractLocation findSafeSpawnLocation(AbstractLocation base, double radiusXZ, double radiusY, int mob_height, boolean yMod) {
        return MobExecutor.findSafeSpawnLocation(base, radiusXZ, radiusY, mob_height, yMod, false);
    }

    public static AbstractLocation findSafeSpawnLocation(AbstractLocation base, double radiusXZ, double radiusY, int mob_height) {
        return MobExecutor.findSafeSpawnLocation(base, radiusXZ, radiusY, mob_height, true, false);
    }

    public static AbstractLocation findSafeSpawnLocation(AbstractLocation base, double radius, int mob_height) {
        return MobExecutor.findSafeSpawnLocation(base, radius, radius, mob_height, true, false);
    }

    public Collection<ActiveMob> getMobsInCombat() {
        return this.activeMobsInCombat.values();
    }

    public boolean getInCombat(ActiveMob am) {
        return this.activeMobsInCombat.containsKey(am.getUniqueId());
    }

    public void setInCombat(ActiveMob am, boolean b) {
        if (b) {
            this.activeMobsInCombat.put(am.getUniqueId(), am);
        } else {
            this.activeMobsInCombat.remove(am.getUniqueId());
        }
    }

    public void saveCachedActiveMobs() {
        Schedulers.async().run(() -> {});
    }

    public List<LivingEntity> getAllMythicEntities() {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (World w : Bukkit.getWorlds()) {
            for (LivingEntity e : w.getLivingEntities()) {
                if (!this.mobRegistry.isActiveMob(e.getUniqueId())) continue;
                list.add(e);
            }
        }
        return list;
    }

    @Override
    public Optional<MythicMob> getMythicMob(String type) {
        return Optional.ofNullable(this.mmList.getOrDefault(type, null));
    }

    public MobStack getMythicMobStack(String s2) {
        for (MobStack ML : this.listMobStacks) {
            if (!ML.getName().equals(s2)) continue;
            return ML;
        }
        return null;
    }

    public static int getMythicMobLevel(MythicMob mm4, AbstractEntity l) {
        int si;
        Scoreboard sb = Bukkit.getScoreboardManager().getMainScoreboard();
        Objective o = sb.getObjective("MythicMobLevel");
        if (o != null && (si = o.getScore(l.getUniqueId().toString()).getScore()) > 0) {
            return si;
        }
        int level = 1;
        if (!(mm4.getPerLevelHealth() > 0.0)) {
            return 1;
        }
        double health = l.getMaxHealth() - mm4.getHealth().get();
        return level += (int)(health / mm4.getPerLevelHealth());
    }

    public static void setMetaData(AbstractEntity abstractEntity, String s2, String key) {
        BukkitAdapter.adapt(abstractEntity).setMetadata(key, (MetadataValue)new FixedMetadataValue((Plugin)MythicBukkit.inst(), (Object)s2));
    }

    public MythicMob determineMobType(AbstractEntity l) {
        List list = l.getBukkitEntity().getMetadata("mobname");
        MythicMob mm4 = null;
        for (MetadataValue mv : list) {
            mm4 = this.mmList.get(mv);
            if (mm4 == null) continue;
            return mm4;
        }
        if (l.getCustomName() == null) {
            return null;
        }
        mm4 = this.mmDisplayLookup.get(l.getCustomName());
        if (mm4 != null) {
            return mm4;
        }
        for (MythicMob MM : this.mmList.values()) {
            if (MM.getDisplayName() == null) continue;
            String search = MM.getDisplayName().toString();
            search = search.replace("[", "\\[");
            search = search.replace("]", "\\]");
            search = search.replace("?", "\\?");
            search = search.replace("$level", "[0-9]*");
            search = search.replace("<mob.level>", "[0-9]*");
            search = ChatColor.translateAlternateColorCodes((char)'&', (String)search);
            try {
                if (!l.getCustomName().toString().matches(search) || !(MM.getHealth().get() <= l.getMaxHealth())) continue;
                l.setHealth(l.getMaxHealth());
                return MM;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public MythicMob getMythicMobByDisplayCompat(AbstractEntity l) {
        if (l.getCustomName() == null) {
            return null;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "-- Attempting to match mob for compatibility: " + l.getCustomName().toString(), new Object[0]);
        MythicMob mm4 = this.mmDisplayLookup.get(l.getCustomName());
        if (mm4 != null) {
            return mm4;
        }
        mm4 = this.determineMobType(l);
        if (mm4 != null) {
            return mm4;
        }
        for (MythicMob MM : this.mmList.values()) {
            if (MM.getDisplayName() == null) continue;
            String search = MM.getDisplayName().toString();
            search = search.replace("?", "\\?");
            search = search.replace("$level", "[0-9]*");
            search = ChatColor.translateAlternateColorCodes((char)'&', (String)search);
            try {
                String name = ChatColor.translateAlternateColorCodes((char)'&', (String)l.getCustomName().toString());
                if (!name.matches(search)) continue;
                l.setHealth(l.getMaxHealth());
                return MM;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String convertMobTypeAliases(String s2) {
        s2 = s2.toLowerCase();
        s2 = s2.replace("armorstand", "ARMOR_STAND");
        s2 = s2.replace("zombievillager", "ZOMBIE_VILLAGER");
        s2 = s2.replace("villagezombie", "ZOMBIE_VILLAGER");
        s2 = s2.replace("babydrowned", "BABY_DROWNED");
        s2 = s2.replace("babyvillagezombie", "BABY_ZOMBIE_VILLAGER");
        s2 = s2.replace("babypigzombie", "BABY_PIG_ZOMBIE");
        s2 = s2.replace("babyzombiepig", "BABY_PIG_ZOMBIE");
        s2 = s2.replace("babyzombiepigman", "BABY_PIG_ZOMBIE");
        s2 = s2.replace("babypigzombievillager", "BABY_PIG_ZOMBIE_VILLAGER");
        s2 = s2.replace("babyzombiepigvillager", "BABY_PIG_ZOMBIE_VILLAGER");
        s2 = s2.replace("babyzombiepigmanvillager", "BABY_PIG_ZOMBIE_VILLAGER");
        s2 = s2.replace("babyzombie", "BABY_ZOMBIE");
        s2 = s2.replace("cavespider", "CAVE_SPIDER");
        s2 = s2.replace("enderdragon", "ENDER_DRAGON");
        s2 = s2.replace("glowsquid", "GLOW_SQUID");
        s2 = s2.replace("glowingsquid", "GLOW_SQUID");
        s2 = s2.replace("irongolem", "IRON_GOLEM");
        s2 = s2.replace("lavaslime", "MAGMA_CUBE");
        s2 = s2.replace("magmacube", "MAGMA_CUBE");
        s2 = s2.replace("mooshroom", "MUSHROOM_COW");
        s2 = s2.replace("mushroomcow", "MUSHROOM_COW");
        s2 = s2.replace("pigzombie", "ZOMBIFIED_PIGLIN");
        s2 = s2.replace("pig_zombie", "ZOMBIFIED_PIGLIN");
        s2 = s2.replace("zombiepig", "ZOMBIFIED_PIGLIN");
        s2 = s2.replace("zombiepigman", "ZOMBIFIED_PIGLIN");
        s2 = s2.replace("pigzombievillager", "ZOMBIFIED_PIGLIN");
        s2 = s2.replace("zombiepigvillager", "ZOMBIFIED_PIGLIN");
        s2 = s2.replace("zombiepigmanvillager", "ZOMBIFIED_PIGLIN");
        s2 = s2.replace("tnt", "PRIMED_TNT");
        s2 = s2.replace("tropicalfish", "TROPICAL_FISH");
        s2 = s2.replace("skeletalhorse", "SKELETON_HORSE");
        s2 = s2.replace("skeletonhorse", "SKELETON_HORSE");
        s2 = s2.replace("zombiehorse", "ZOMBIE_HORSE");
        s2 = s2.replace("witherskeleton", "WITHER_SKELETON");
        return s2;
    }

    public Collection<MobType> filterMobs(Collection<MobType> mobs, String ffilter) {
        String filter = ffilter.toUpperCase();
        mobs.removeIf(mi -> {
            boolean remove = true;
            if (mi.getInternalName().toUpperCase().contains(filter)) {
                remove = false;
            } else if (mi.getDisplayName() != null && mi.getDisplayName().toString().toUpperCase().contains(filter)) {
                remove = false;
            } else if (mi.getEntityType().toString() != null && mi.getEntityType().toString().contains(filter)) {
                remove = false;
            }
            return remove;
        });
        return mobs;
    }

    public MobRegistry getMobRegistry() {
        return this.mobRegistry;
    }
}

