/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.packs;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyHolder;
import io.lumine.mythic.bukkit.utils.config.properties.types.ItemProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringListProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringProp;
import io.lumine.mythic.bukkit.utils.menu.Icon;
import io.lumine.mythic.bukkit.utils.menu.IconBuilder;
import io.lumine.mythic.core.config.Scope;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PackImpl
implements Pack,
PropertyHolder {
    private static final StringProp NAME = Property.String(Scope.PACK, "Name");
    private static final StringListProp DESCRIPTION = Property.StringList(Scope.PACK, "Description");
    private static final StringProp AUTHOR = Property.String(Scope.PACK, "Author");
    private static final StringProp URL = Property.String(Scope.PACK, "URL");
    private static final StringProp VERSION = Property.String(Scope.PACK, "Version");
    private static final ItemProp ICON = Property.Item(Scope.PACK, "Icon");
    private final File folder;
    private final String key;
    private String name = null;
    private List<String> description;
    private String author = null;
    private String url = null;
    private String version = null;
    private ItemStack icon = null;
    private List<String> fullDescription;

    public PackImpl(MythicBukkit plugin) {
        this.folder = plugin.getDataFolder();
        this.key = "Mythic";
        this.name = "<gold>Mythic Base Pack";
        this.description = Lists.newArrayList((Object[])new String[]{"The Mythic Base Pack", "Located in the plugin directory"});
        this.author = "MythicCraft";
        this.version = "1.0.0";
        this.url = "https://www.mythiccraft.io";
        this.icon = new ItemStack(Material.CHEST);
        this.setupDescription();
    }

    public PackImpl(File folder) {
        this.folder = folder;
        this.key = folder.getName();
        File packinfo = new File(folder, "packinfo.yml");
        if (packinfo.exists() && packinfo.isFile()) {
            this.name = (String)NAME.fget(packinfo);
            this.description = (List)DESCRIPTION.fget(packinfo);
            this.author = (String)AUTHOR.fget(packinfo);
            this.url = (String)URL.fget(packinfo);
            this.version = (String)VERSION.fget(packinfo);
            this.icon = (ItemStack)ICON.fget(packinfo);
        }
        this.setDefaultData();
        this.setupDescription();
    }

    private void setDefaultData() {
        if (this.name == null) {
            this.name = "<gold>" + this.folder.getName();
        }
        if (this.description == null) {
            this.description = Collections.emptyList();
        }
        if (this.author == null) {
            this.author = "Unknown";
        }
        if (this.url == null) {
            this.url = "";
        }
        if (this.version == null) {
            this.version = "";
        }
        if (this.icon == null) {
            this.icon = new ItemStack(Material.CHEST);
        }
    }

    private void setupDescription() {
        this.fullDescription = Lists.newArrayList();
        if (!this.author.isEmpty()) {
            this.fullDescription.add("<yellow>Author<white>: " + this.author);
        }
        if (!this.url.isEmpty()) {
            this.fullDescription.add("<yellow>URL<white>: " + this.url);
        }
        if (!this.version.isEmpty()) {
            this.fullDescription.add("<yellow>Version<white>: " + this.version);
        }
        if (!this.description.isEmpty()) {
            this.fullDescription.add("<gray> ");
        }
        if (!this.description.isEmpty()) {
            this.fullDescription.addAll(this.description);
        }
        this.fullDescription.add("<gray> ");
        this.fullDescription.add("<gray>Click to Open Menu");
    }

    @Override
    public String getPropertyNode() {
        return "";
    }

    @Override
    public File getSchematicDirectory() {
        return new File(this.folder, "Schematics");
    }

    @Override
    public File getPackFolder(String name) {
        return this.getPackFolder(name, false);
    }

    public File getPackFolder(String name, boolean create) {
        if (name.contains("\\.")) {
            throw new IllegalArgumentException("Unsupported folder name");
        }
        File file = new File(this.folder, name);
        if (!file.exists() && create) {
            file.mkdir();
        }
        return file;
    }

    @Override
    public File getPackFile(String name) {
        return new File(this.folder, name);
    }

    @Override
    public <T> Icon<T> createMenuIcon(BiConsumer<T, Player> clickEvent) {
        return IconBuilder.create().itemStack(this.icon).hideFlags(true).name(this.name).lore(this.fullDescription).click(clickEvent).build();
    }

    @Override
    public File getFolder() {
        return this.folder;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<String> getDescription() {
        return this.description;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public List<String> getFullDescription() {
        return this.fullDescription;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(List<String> description) {
        this.description = description;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setIcon(ItemStack icon) {
        this.icon = icon;
    }

    public void setFullDescription(List<String> fullDescription) {
        this.fullDescription = fullDescription;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PackImpl)) {
            return false;
        }
        PackImpl other = (PackImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$folder = this.getFolder();
        File other$folder = other.getFolder();
        if (this$folder == null ? other$folder != null : !((Object)this$folder).equals(other$folder)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$description = this.getDescription();
        List<String> other$description = other.getDescription();
        if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        ItemStack this$icon = this.getIcon();
        ItemStack other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        List<String> this$fullDescription = this.getFullDescription();
        List<String> other$fullDescription = other.getFullDescription();
        return !(this$fullDescription == null ? other$fullDescription != null : !((Object)this$fullDescription).equals(other$fullDescription));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PackImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $folder = this.getFolder();
        result = result * 59 + ($folder == null ? 43 : ((Object)$folder).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        ItemStack $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        List<String> $fullDescription = this.getFullDescription();
        result = result * 59 + ($fullDescription == null ? 43 : ((Object)$fullDescription).hashCode());
        return result;
    }

    public String toString() {
        return "PackImpl(folder=" + this.getFolder() + ", key=" + this.getKey() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", author=" + this.getAuthor() + ", url=" + this.getUrl() + ", version=" + this.getVersion() + ", icon=" + this.getIcon() + ", fullDescription=" + this.getFullDescription() + ")";
    }
}

